/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.S3Config;
import software.amazon.awssdk.services.forecast.model.Schema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesReplacementsDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesReplacementsDataSource> {
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Config").getter(TimeSeriesReplacementsDataSource.getter(TimeSeriesReplacementsDataSource::s3Config)).setter(TimeSeriesReplacementsDataSource.setter(Builder::s3Config)).constructor(S3Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()}).build();
    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schema").getter(TimeSeriesReplacementsDataSource.getter(TimeSeriesReplacementsDataSource::schema)).setter(TimeSeriesReplacementsDataSource.setter(Builder::schema)).constructor(Schema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(TimeSeriesReplacementsDataSource.getter(TimeSeriesReplacementsDataSource::format)).setter(TimeSeriesReplacementsDataSource.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampFormat").getter(TimeSeriesReplacementsDataSource.getter(TimeSeriesReplacementsDataSource::timestampFormat)).setter(TimeSeriesReplacementsDataSource.setter(Builder::timestampFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIG_FIELD, SCHEMA_FIELD, FORMAT_FIELD, TIMESTAMP_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeSeriesReplacementsDataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Config s3Config;
    private final Schema schema;
    private final String format;
    private final String timestampFormat;

    private TimeSeriesReplacementsDataSource(BuilderImpl builder) {
        this.s3Config = builder.s3Config;
        this.schema = builder.schema;
        this.format = builder.format;
        this.timestampFormat = builder.timestampFormat;
    }

    public final S3Config s3Config() {
        return this.s3Config;
    }

    public final Schema schema() {
        return this.schema;
    }

    public final String format() {
        return this.format;
    }

    public final String timestampFormat() {
        return this.timestampFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesReplacementsDataSource)) {
            return false;
        }
        TimeSeriesReplacementsDataSource other = (TimeSeriesReplacementsDataSource)obj;
        return Objects.equals(this.s3Config(), other.s3Config()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.timestampFormat(), other.timestampFormat());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesReplacementsDataSource").add("S3Config", (Object)this.s3Config()).add("Schema", (Object)this.schema()).add("Format", (Object)this.format()).add("TimestampFormat", (Object)this.timestampFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Config": {
                return Optional.ofNullable(clazz.cast(this.s3Config()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "TimestampFormat": {
                return Optional.ofNullable(clazz.cast(this.timestampFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3Config", S3_CONFIG_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("TimestampFormat", TIMESTAMP_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesReplacementsDataSource, T> g) {
        return obj -> g.apply((TimeSeriesReplacementsDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Config s3Config;
        private Schema schema;
        private String format;
        private String timestampFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesReplacementsDataSource model) {
            this.s3Config(model.s3Config);
            this.schema(model.schema);
            this.format(model.format);
            this.timestampFormat(model.timestampFormat);
        }

        public final S3Config.Builder getS3Config() {
            return this.s3Config != null ? this.s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final Schema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getTimestampFormat() {
            return this.timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public TimeSeriesReplacementsDataSource build() {
            return new TimeSeriesReplacementsDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesReplacementsDataSource> {
        public Builder s3Config(S3Config var1);

        default public Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return this.s3Config((S3Config)((S3Config.Builder)S3Config.builder().applyMutation(s3Config)).build());
        }

        public Builder schema(Schema var1);

        default public Builder schema(Consumer<Schema.Builder> schema) {
            return this.schema((Schema)((Schema.Builder)Schema.builder().applyMutation(schema)).build());
        }

        public Builder format(String var1);

        public Builder timestampFormat(String var1);
    }
}

