/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLOverrideStrategy {
    LATENCY_OPTIMIZED("LatencyOptimized"),
    ACCURACY_OPTIMIZED("AccuracyOptimized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLOverrideStrategy> VALUE_MAP;
    private final String value;

    private AutoMLOverrideStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLOverrideStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLOverrideStrategy> knownValues() {
        EnumSet<AutoMLOverrideStrategy> knownValues = EnumSet.allOf(AutoMLOverrideStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLOverrideStrategy.class, AutoMLOverrideStrategy::toString);
    }
}

