/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ArnListCopier;
import software.amazon.awssdk.services.forecast.model.Domain;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetGroupRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateDatasetGroupRequest> {
    private static final SdkField<String> DATASET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetGroupName").getter(CreateDatasetGroupRequest.getter(CreateDatasetGroupRequest::datasetGroupName)).setter(CreateDatasetGroupRequest.setter(Builder::datasetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupName").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(CreateDatasetGroupRequest.getter(CreateDatasetGroupRequest::domainAsString)).setter(CreateDatasetGroupRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<List<String>> DATASET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetArns").getter(CreateDatasetGroupRequest.getter(CreateDatasetGroupRequest::datasetArns)).setter(CreateDatasetGroupRequest.setter(Builder::datasetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDatasetGroupRequest.getter(CreateDatasetGroupRequest::tags)).setter(CreateDatasetGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_NAME_FIELD, DOMAIN_FIELD, DATASET_ARNS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDatasetGroupRequest.memberNameToFieldInitializer();
    private final String datasetGroupName;
    private final String domain;
    private final List<String> datasetArns;
    private final List<Tag> tags;

    private CreateDatasetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.datasetGroupName = builder.datasetGroupName;
        this.domain = builder.domain;
        this.datasetArns = builder.datasetArns;
        this.tags = builder.tags;
    }

    public final String datasetGroupName() {
        return this.datasetGroupName;
    }

    public final Domain domain() {
        return Domain.fromValue(this.domain);
    }

    public final String domainAsString() {
        return this.domain;
    }

    public final boolean hasDatasetArns() {
        return this.datasetArns != null && !(this.datasetArns instanceof SdkAutoConstructList);
    }

    public final List<String> datasetArns() {
        return this.datasetArns;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetArns() ? this.datasetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetGroupRequest)) {
            return false;
        }
        CreateDatasetGroupRequest other = (CreateDatasetGroupRequest)((Object)obj);
        return Objects.equals(this.datasetGroupName(), other.datasetGroupName()) && Objects.equals(this.domainAsString(), other.domainAsString()) && this.hasDatasetArns() == other.hasDatasetArns() && Objects.equals(this.datasetArns(), other.datasetArns()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetGroupRequest").add("DatasetGroupName", (Object)this.datasetGroupName()).add("Domain", (Object)this.domainAsString()).add("DatasetArns", this.hasDatasetArns() ? this.datasetArns() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetGroupName": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupName()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "DatasetArns": {
                return Optional.ofNullable(clazz.cast(this.datasetArns()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasetGroupName", DATASET_GROUP_NAME_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DatasetArns", DATASET_ARNS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetGroupRequest, T> g) {
        return obj -> g.apply((CreateDatasetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String datasetGroupName;
        private String domain;
        private List<String> datasetArns = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetGroupRequest model) {
            super(model);
            this.datasetGroupName(model.datasetGroupName);
            this.domain(model.domain);
            this.datasetArns(model.datasetArns);
            this.tags(model.tags);
        }

        public final String getDatasetGroupName() {
            return this.datasetGroupName;
        }

        public final void setDatasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
        }

        @Override
        public final Builder datasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final Collection<String> getDatasetArns() {
            if (this.datasetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasetArns;
        }

        public final void setDatasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
        }

        @Override
        public final Builder datasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetArns(String ... datasetArns) {
            this.datasetArns(Arrays.asList(datasetArns));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetGroupRequest build() {
            return new CreateDatasetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetGroupRequest> {
        public Builder datasetGroupName(String var1);

        public Builder domain(String var1);

        public Builder domain(Domain var1);

        public Builder datasetArns(Collection<String> var1);

        public Builder datasetArns(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

