/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ExplainabilitiesCopier;
import software.amazon.awssdk.services.forecast.model.ExplainabilitySummary;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExplainabilitiesResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListExplainabilitiesResponse> {
    private static final SdkField<List<ExplainabilitySummary>> EXPLAINABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Explainabilities").getter(ListExplainabilitiesResponse.getter(ListExplainabilitiesResponse::explainabilities)).setter(ListExplainabilitiesResponse.setter(Builder::explainabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExplainabilitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExplainabilitiesResponse.getter(ListExplainabilitiesResponse::nextToken)).setter(ListExplainabilitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Explainabilities", EXPLAINABILITIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ExplainabilitySummary> explainabilities;
    private final String nextToken;

    private ListExplainabilitiesResponse(BuilderImpl builder) {
        super(builder);
        this.explainabilities = builder.explainabilities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExplainabilities() {
        return this.explainabilities != null && !(this.explainabilities instanceof SdkAutoConstructList);
    }

    public final List<ExplainabilitySummary> explainabilities() {
        return this.explainabilities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExplainabilities() ? this.explainabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExplainabilitiesResponse)) {
            return false;
        }
        ListExplainabilitiesResponse other = (ListExplainabilitiesResponse)((Object)obj);
        return this.hasExplainabilities() == other.hasExplainabilities() && Objects.equals(this.explainabilities(), other.explainabilities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExplainabilitiesResponse").add("Explainabilities", this.hasExplainabilities() ? this.explainabilities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Explainabilities": {
                return Optional.ofNullable(clazz.cast(this.explainabilities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListExplainabilitiesResponse, T> g) {
        return obj -> g.apply((ListExplainabilitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<ExplainabilitySummary> explainabilities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExplainabilitiesResponse model) {
            super(model);
            this.explainabilities(model.explainabilities);
            this.nextToken(model.nextToken);
        }

        public final List<ExplainabilitySummary.Builder> getExplainabilities() {
            List<ExplainabilitySummary.Builder> result = ExplainabilitiesCopier.copyToBuilder(this.explainabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExplainabilities(Collection<ExplainabilitySummary.BuilderImpl> explainabilities) {
            this.explainabilities = ExplainabilitiesCopier.copyFromBuilder(explainabilities);
        }

        @Override
        public final Builder explainabilities(Collection<ExplainabilitySummary> explainabilities) {
            this.explainabilities = ExplainabilitiesCopier.copy(explainabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explainabilities(ExplainabilitySummary ... explainabilities) {
            this.explainabilities(Arrays.asList(explainabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explainabilities(Consumer<ExplainabilitySummary.Builder> ... explainabilities) {
            this.explainabilities(Stream.of(explainabilities).map(c -> (ExplainabilitySummary)((ExplainabilitySummary.Builder)ExplainabilitySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExplainabilitiesResponse build() {
            return new ListExplainabilitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExplainabilitiesResponse> {
        public Builder explainabilities(Collection<ExplainabilitySummary> var1);

        public Builder explainabilities(ExplainabilitySummary ... var1);

        public Builder explainabilities(Consumer<ExplainabilitySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

