/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.DataDestination;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.LongArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWhatIfForecastExportResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeWhatIfForecastExportResponse> {
    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfForecastExportArn").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::whatIfForecastExportArn)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::whatIfForecastExportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportArn").build()}).build();
    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfForecastExportName").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::whatIfForecastExportName)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::whatIfForecastExportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportName").build()}).build();
    private static final SdkField<List<String>> WHAT_IF_FORECAST_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WhatIfForecastArns").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::whatIfForecastArns)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::whatIfForecastArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::destination)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::destination)).constructor(DataDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::message)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::status)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::creationTime)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeRemainingInMinutes").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::estimatedTimeRemainingInMinutes)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::estimatedTimeRemainingInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::lastModificationTime)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(DescribeWhatIfForecastExportResponse.getter(DescribeWhatIfForecastExportResponse::format)).setter(DescribeWhatIfForecastExportResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_FORECAST_EXPORT_ARN_FIELD, WHAT_IF_FORECAST_EXPORT_NAME_FIELD, WHAT_IF_FORECAST_ARNS_FIELD, DESTINATION_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, LAST_MODIFICATION_TIME_FIELD, FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WhatIfForecastExportArn", WHAT_IF_FORECAST_EXPORT_ARN_FIELD);
            this.put("WhatIfForecastExportName", WHAT_IF_FORECAST_EXPORT_NAME_FIELD);
            this.put("WhatIfForecastArns", WHAT_IF_FORECAST_ARNS_FIELD);
            this.put("Destination", DESTINATION_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
            this.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
            this.put("Format", FORMAT_FIELD);
        }
    });
    private final String whatIfForecastExportArn;
    private final String whatIfForecastExportName;
    private final List<String> whatIfForecastArns;
    private final DataDestination destination;
    private final String message;
    private final String status;
    private final Instant creationTime;
    private final Long estimatedTimeRemainingInMinutes;
    private final Instant lastModificationTime;
    private final String format;

    private DescribeWhatIfForecastExportResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastExportArn = builder.whatIfForecastExportArn;
        this.whatIfForecastExportName = builder.whatIfForecastExportName;
        this.whatIfForecastArns = builder.whatIfForecastArns;
        this.destination = builder.destination;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.lastModificationTime = builder.lastModificationTime;
        this.format = builder.format;
    }

    public final String whatIfForecastExportArn() {
        return this.whatIfForecastExportArn;
    }

    public final String whatIfForecastExportName() {
        return this.whatIfForecastExportName;
    }

    public final boolean hasWhatIfForecastArns() {
        return this.whatIfForecastArns != null && !(this.whatIfForecastArns instanceof SdkAutoConstructList);
    }

    public final List<String> whatIfForecastArns() {
        return this.whatIfForecastArns;
    }

    public final DataDestination destination() {
        return this.destination;
    }

    public final String message() {
        return this.message;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Long estimatedTimeRemainingInMinutes() {
        return this.estimatedTimeRemainingInMinutes;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final String format() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfForecastExportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfForecastExportName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWhatIfForecastArns() ? this.whatIfForecastArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWhatIfForecastExportResponse)) {
            return false;
        }
        DescribeWhatIfForecastExportResponse other = (DescribeWhatIfForecastExportResponse)((Object)obj);
        return Objects.equals(this.whatIfForecastExportArn(), other.whatIfForecastExportArn()) && Objects.equals(this.whatIfForecastExportName(), other.whatIfForecastExportName()) && this.hasWhatIfForecastArns() == other.hasWhatIfForecastArns() && Objects.equals(this.whatIfForecastArns(), other.whatIfForecastArns()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.format(), other.format());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWhatIfForecastExportResponse").add("WhatIfForecastExportArn", (Object)this.whatIfForecastExportArn()).add("WhatIfForecastExportName", (Object)this.whatIfForecastExportName()).add("WhatIfForecastArns", this.hasWhatIfForecastArns() ? this.whatIfForecastArns() : null).add("Destination", (Object)this.destination()).add("Message", (Object)this.message()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("EstimatedTimeRemainingInMinutes", (Object)this.estimatedTimeRemainingInMinutes()).add("LastModificationTime", (Object)this.lastModificationTime()).add("Format", (Object)this.format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WhatIfForecastExportArn": {
                return Optional.ofNullable(clazz.cast(this.whatIfForecastExportArn()));
            }
            case "WhatIfForecastExportName": {
                return Optional.ofNullable(clazz.cast(this.whatIfForecastExportName()));
            }
            case "WhatIfForecastArns": {
                return Optional.ofNullable(clazz.cast(this.whatIfForecastArns()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EstimatedTimeRemainingInMinutes": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeRemainingInMinutes()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWhatIfForecastExportResponse, T> g) {
        return obj -> g.apply((DescribeWhatIfForecastExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String whatIfForecastExportArn;
        private String whatIfForecastExportName;
        private List<String> whatIfForecastArns = DefaultSdkAutoConstructList.getInstance();
        private DataDestination destination;
        private String message;
        private String status;
        private Instant creationTime;
        private Long estimatedTimeRemainingInMinutes;
        private Instant lastModificationTime;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWhatIfForecastExportResponse model) {
            super(model);
            this.whatIfForecastExportArn(model.whatIfForecastExportArn);
            this.whatIfForecastExportName(model.whatIfForecastExportName);
            this.whatIfForecastArns(model.whatIfForecastArns);
            this.destination(model.destination);
            this.message(model.message);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            this.lastModificationTime(model.lastModificationTime);
            this.format(model.format);
        }

        public final String getWhatIfForecastExportArn() {
            return this.whatIfForecastExportArn;
        }

        public final void setWhatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
        }

        @Override
        public final Builder whatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
            return this;
        }

        public final String getWhatIfForecastExportName() {
            return this.whatIfForecastExportName;
        }

        public final void setWhatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
        }

        @Override
        public final Builder whatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
            return this;
        }

        public final Collection<String> getWhatIfForecastArns() {
            if (this.whatIfForecastArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.whatIfForecastArns;
        }

        public final void setWhatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = LongArnListCopier.copy(whatIfForecastArns);
        }

        @Override
        public final Builder whatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = LongArnListCopier.copy(whatIfForecastArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecastArns(String ... whatIfForecastArns) {
            this.whatIfForecastArns(Arrays.asList(whatIfForecastArns));
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return this.estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public DescribeWhatIfForecastExportResponse build() {
            return new DescribeWhatIfForecastExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWhatIfForecastExportResponse> {
        public Builder whatIfForecastExportArn(String var1);

        public Builder whatIfForecastExportName(String var1);

        public Builder whatIfForecastArns(Collection<String> var1);

        public Builder whatIfForecastArns(String ... var1);

        public Builder destination(DataDestination var1);

        default public Builder destination(Consumer<DataDestination.Builder> destination) {
            return this.destination((DataDestination)((DataDestination.Builder)DataDestination.builder().applyMutation(destination)).build());
        }

        public Builder message(String var1);

        public Builder status(String var1);

        public Builder creationTime(Instant var1);

        public Builder estimatedTimeRemainingInMinutes(Long var1);

        public Builder lastModificationTime(Instant var1);

        public Builder format(String var1);
    }
}

