/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.ExplainabilityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExplainabilitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExplainabilitySummary> {
    private static final SdkField<String> EXPLAINABILITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityArn").getter(ExplainabilitySummary.getter(ExplainabilitySummary::explainabilityArn)).setter(ExplainabilitySummary.setter(Builder::explainabilityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityArn").build()}).build();
    private static final SdkField<String> EXPLAINABILITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityName").getter(ExplainabilitySummary.getter(ExplainabilitySummary::explainabilityName)).setter(ExplainabilitySummary.setter(Builder::explainabilityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ExplainabilitySummary.getter(ExplainabilitySummary::resourceArn)).setter(ExplainabilitySummary.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<ExplainabilityConfig> EXPLAINABILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExplainabilityConfig").getter(ExplainabilitySummary.getter(ExplainabilitySummary::explainabilityConfig)).setter(ExplainabilitySummary.setter(Builder::explainabilityConfig)).constructor(ExplainabilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ExplainabilitySummary.getter(ExplainabilitySummary::status)).setter(ExplainabilitySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ExplainabilitySummary.getter(ExplainabilitySummary::message)).setter(ExplainabilitySummary.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ExplainabilitySummary.getter(ExplainabilitySummary::creationTime)).setter(ExplainabilitySummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(ExplainabilitySummary.getter(ExplainabilitySummary::lastModificationTime)).setter(ExplainabilitySummary.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_ARN_FIELD, EXPLAINABILITY_NAME_FIELD, RESOURCE_ARN_FIELD, EXPLAINABILITY_CONFIG_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExplainabilityArn", EXPLAINABILITY_ARN_FIELD);
            this.put("ExplainabilityName", EXPLAINABILITY_NAME_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ExplainabilityConfig", EXPLAINABILITY_CONFIG_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String explainabilityArn;
    private final String explainabilityName;
    private final String resourceArn;
    private final ExplainabilityConfig explainabilityConfig;
    private final String status;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private ExplainabilitySummary(BuilderImpl builder) {
        this.explainabilityArn = builder.explainabilityArn;
        this.explainabilityName = builder.explainabilityName;
        this.resourceArn = builder.resourceArn;
        this.explainabilityConfig = builder.explainabilityConfig;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public final String explainabilityArn() {
        return this.explainabilityArn;
    }

    public final String explainabilityName() {
        return this.explainabilityName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ExplainabilityConfig explainabilityConfig() {
        return this.explainabilityConfig;
    }

    public final String status() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExplainabilitySummary)) {
            return false;
        }
        ExplainabilitySummary other = (ExplainabilitySummary)obj;
        return Objects.equals(this.explainabilityArn(), other.explainabilityArn()) && Objects.equals(this.explainabilityName(), other.explainabilityName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.explainabilityConfig(), other.explainabilityConfig()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ExplainabilitySummary").add("ExplainabilityArn", (Object)this.explainabilityArn()).add("ExplainabilityName", (Object)this.explainabilityName()).add("ResourceArn", (Object)this.resourceArn()).add("ExplainabilityConfig", (Object)this.explainabilityConfig()).add("Status", (Object)this.status()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExplainabilityArn": {
                return Optional.ofNullable(clazz.cast(this.explainabilityArn()));
            }
            case "ExplainabilityName": {
                return Optional.ofNullable(clazz.cast(this.explainabilityName()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ExplainabilityConfig": {
                return Optional.ofNullable(clazz.cast(this.explainabilityConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExplainabilitySummary, T> g) {
        return obj -> g.apply((ExplainabilitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String explainabilityArn;
        private String explainabilityName;
        private String resourceArn;
        private ExplainabilityConfig explainabilityConfig;
        private String status;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExplainabilitySummary model) {
            this.explainabilityArn(model.explainabilityArn);
            this.explainabilityName(model.explainabilityName);
            this.resourceArn(model.resourceArn);
            this.explainabilityConfig(model.explainabilityConfig);
            this.status(model.status);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getExplainabilityArn() {
            return this.explainabilityArn;
        }

        public final void setExplainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
        }

        @Override
        public final Builder explainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
            return this;
        }

        public final String getExplainabilityName() {
            return this.explainabilityName;
        }

        public final void setExplainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
        }

        @Override
        public final Builder explainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ExplainabilityConfig.Builder getExplainabilityConfig() {
            return this.explainabilityConfig != null ? this.explainabilityConfig.toBuilder() : null;
        }

        public final void setExplainabilityConfig(ExplainabilityConfig.BuilderImpl explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig != null ? explainabilityConfig.build() : null;
        }

        @Override
        public final Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public ExplainabilitySummary build() {
            return new ExplainabilitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExplainabilitySummary> {
        public Builder explainabilityArn(String var1);

        public Builder explainabilityName(String var1);

        public Builder resourceArn(String var1);

        public Builder explainabilityConfig(ExplainabilityConfig var1);

        default public Builder explainabilityConfig(Consumer<ExplainabilityConfig.Builder> explainabilityConfig) {
            return this.explainabilityConfig((ExplainabilityConfig)((ExplainabilityConfig.Builder)ExplainabilityConfig.builder().applyMutation(explainabilityConfig)).build());
        }

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

