/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary;

public class ListWhatIfAnalysesPublisher
implements SdkPublisher<ListWhatIfAnalysesResponse> {
    private final ForecastAsyncClient client;
    private final ListWhatIfAnalysesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWhatIfAnalysesPublisher(ForecastAsyncClient client, ListWhatIfAnalysesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWhatIfAnalysesPublisher(ForecastAsyncClient client, ListWhatIfAnalysesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWhatIfAnalysesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWhatIfAnalysesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WhatIfAnalysisSummary> whatIfAnalyses() {
        Function<ListWhatIfAnalysesResponse, Iterator> getIterator = response -> {
            if (response != null && response.whatIfAnalyses() != null) {
                return response.whatIfAnalyses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWhatIfAnalysesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWhatIfAnalysesResponseFetcher
    implements AsyncPageFetcher<ListWhatIfAnalysesResponse> {
        private ListWhatIfAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatIfAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWhatIfAnalysesResponse> nextPage(ListWhatIfAnalysesResponse previousPage) {
            if (previousPage == null) {
                return ListWhatIfAnalysesPublisher.this.client.listWhatIfAnalyses(ListWhatIfAnalysesPublisher.this.firstRequest);
            }
            return ListWhatIfAnalysesPublisher.this.client.listWhatIfAnalyses((ListWhatIfAnalysesRequest)((Object)ListWhatIfAnalysesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

