/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.services.forecast.model.TimeSeriesReplacementsDataSource;
import software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation;
import software.amazon.awssdk.services.forecast.model.TimeSeriesTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWhatIfForecastRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateWhatIfForecastRequest> {
    private static final SdkField<String> WHAT_IF_FORECAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfForecastName").getter(CreateWhatIfForecastRequest.getter(CreateWhatIfForecastRequest::whatIfForecastName)).setter(CreateWhatIfForecastRequest.setter(Builder::whatIfForecastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastName").build()}).build();
    private static final SdkField<String> WHAT_IF_ANALYSIS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfAnalysisArn").getter(CreateWhatIfForecastRequest.getter(CreateWhatIfForecastRequest::whatIfAnalysisArn)).setter(CreateWhatIfForecastRequest.setter(Builder::whatIfAnalysisArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisArn").build()}).build();
    private static final SdkField<List<TimeSeriesTransformation>> TIME_SERIES_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeSeriesTransformations").getter(CreateWhatIfForecastRequest.getter(CreateWhatIfForecastRequest::timeSeriesTransformations)).setter(CreateWhatIfForecastRequest.setter(Builder::timeSeriesTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimeSeriesReplacementsDataSource> TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesReplacementsDataSource").getter(CreateWhatIfForecastRequest.getter(CreateWhatIfForecastRequest::timeSeriesReplacementsDataSource)).setter(CreateWhatIfForecastRequest.setter(Builder::timeSeriesReplacementsDataSource)).constructor(TimeSeriesReplacementsDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesReplacementsDataSource").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWhatIfForecastRequest.getter(CreateWhatIfForecastRequest::tags)).setter(CreateWhatIfForecastRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_FORECAST_NAME_FIELD, WHAT_IF_ANALYSIS_ARN_FIELD, TIME_SERIES_TRANSFORMATIONS_FIELD, TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD, TAGS_FIELD));
    private final String whatIfForecastName;
    private final String whatIfAnalysisArn;
    private final List<TimeSeriesTransformation> timeSeriesTransformations;
    private final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;
    private final List<Tag> tags;

    private CreateWhatIfForecastRequest(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastName = builder.whatIfForecastName;
        this.whatIfAnalysisArn = builder.whatIfAnalysisArn;
        this.timeSeriesTransformations = builder.timeSeriesTransformations;
        this.timeSeriesReplacementsDataSource = builder.timeSeriesReplacementsDataSource;
        this.tags = builder.tags;
    }

    public final String whatIfForecastName() {
        return this.whatIfForecastName;
    }

    public final String whatIfAnalysisArn() {
        return this.whatIfAnalysisArn;
    }

    public final boolean hasTimeSeriesTransformations() {
        return this.timeSeriesTransformations != null && !(this.timeSeriesTransformations instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesTransformation> timeSeriesTransformations() {
        return this.timeSeriesTransformations;
    }

    public final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource() {
        return this.timeSeriesReplacementsDataSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfForecastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeSeriesTransformations() ? this.timeSeriesTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesReplacementsDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatIfForecastRequest)) {
            return false;
        }
        CreateWhatIfForecastRequest other = (CreateWhatIfForecastRequest)((Object)obj);
        return Objects.equals(this.whatIfForecastName(), other.whatIfForecastName()) && Objects.equals(this.whatIfAnalysisArn(), other.whatIfAnalysisArn()) && this.hasTimeSeriesTransformations() == other.hasTimeSeriesTransformations() && Objects.equals(this.timeSeriesTransformations(), other.timeSeriesTransformations()) && Objects.equals(this.timeSeriesReplacementsDataSource(), other.timeSeriesReplacementsDataSource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWhatIfForecastRequest").add("WhatIfForecastName", (Object)this.whatIfForecastName()).add("WhatIfAnalysisArn", (Object)this.whatIfAnalysisArn()).add("TimeSeriesTransformations", this.hasTimeSeriesTransformations() ? this.timeSeriesTransformations() : null).add("TimeSeriesReplacementsDataSource", (Object)this.timeSeriesReplacementsDataSource()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WhatIfForecastName": {
                return Optional.ofNullable(clazz.cast(this.whatIfForecastName()));
            }
            case "WhatIfAnalysisArn": {
                return Optional.ofNullable(clazz.cast(this.whatIfAnalysisArn()));
            }
            case "TimeSeriesTransformations": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesTransformations()));
            }
            case "TimeSeriesReplacementsDataSource": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesReplacementsDataSource()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatIfForecastRequest, T> g) {
        return obj -> g.apply((CreateWhatIfForecastRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String whatIfForecastName;
        private String whatIfAnalysisArn;
        private List<TimeSeriesTransformation> timeSeriesTransformations = DefaultSdkAutoConstructList.getInstance();
        private TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatIfForecastRequest model) {
            super(model);
            this.whatIfForecastName(model.whatIfForecastName);
            this.whatIfAnalysisArn(model.whatIfAnalysisArn);
            this.timeSeriesTransformations(model.timeSeriesTransformations);
            this.timeSeriesReplacementsDataSource(model.timeSeriesReplacementsDataSource);
            this.tags(model.tags);
        }

        public final String getWhatIfForecastName() {
            return this.whatIfForecastName;
        }

        public final void setWhatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
        }

        @Override
        public final Builder whatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
            return this;
        }

        public final String getWhatIfAnalysisArn() {
            return this.whatIfAnalysisArn;
        }

        public final void setWhatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
        }

        @Override
        public final Builder whatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
            return this;
        }

        public final List<TimeSeriesTransformation.Builder> getTimeSeriesTransformations() {
            List<TimeSeriesTransformation.Builder> result = TimeSeriesTransformationsCopier.copyToBuilder(this.timeSeriesTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesTransformations(Collection<TimeSeriesTransformation.BuilderImpl> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copyFromBuilder(timeSeriesTransformations);
        }

        @Override
        public final Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copy(timeSeriesTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(TimeSeriesTransformation ... timeSeriesTransformations) {
            this.timeSeriesTransformations(Arrays.asList(timeSeriesTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder> ... timeSeriesTransformations) {
            this.timeSeriesTransformations(Stream.of(timeSeriesTransformations).map(c -> (TimeSeriesTransformation)((TimeSeriesTransformation.Builder)TimeSeriesTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimeSeriesReplacementsDataSource.Builder getTimeSeriesReplacementsDataSource() {
            return this.timeSeriesReplacementsDataSource != null ? this.timeSeriesReplacementsDataSource.toBuilder() : null;
        }

        public final void setTimeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource.BuilderImpl timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource != null ? timeSeriesReplacementsDataSource.build() : null;
        }

        @Override
        public final Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWhatIfForecastRequest build() {
            return new CreateWhatIfForecastRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWhatIfForecastRequest> {
        public Builder whatIfForecastName(String var1);

        public Builder whatIfAnalysisArn(String var1);

        public Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> var1);

        public Builder timeSeriesTransformations(TimeSeriesTransformation ... var1);

        public Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder> ... var1);

        public Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource var1);

        default public Builder timeSeriesReplacementsDataSource(Consumer<TimeSeriesReplacementsDataSource.Builder> timeSeriesReplacementsDataSource) {
            return this.timeSeriesReplacementsDataSource((TimeSeriesReplacementsDataSource)((TimeSeriesReplacementsDataSource.Builder)TimeSeriesReplacementsDataSource.builder().applyMutation(timeSeriesReplacementsDataSource)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

