/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ForecastSummary;
import software.amazon.awssdk.services.forecast.model.ListForecastsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastsResponse;

public class ListForecastsIterable
implements SdkIterable<ListForecastsResponse> {
    private final ForecastClient client;
    private final ListForecastsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListForecastsIterable(ForecastClient client, ListForecastsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListForecastsResponseFetcher();
    }

    public Iterator<ListForecastsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ForecastSummary> forecasts() {
        Function<ListForecastsResponse, Iterator> getIterator = response -> {
            if (response != null && response.forecasts() != null) {
                return response.forecasts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListForecastsResponseFetcher
    implements SyncPageFetcher<ListForecastsResponse> {
        private ListForecastsResponseFetcher() {
        }

        public boolean hasNextPage(ListForecastsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListForecastsResponse nextPage(ListForecastsResponse previousPage) {
            if (previousPage == null) {
                return ListForecastsIterable.this.client.listForecasts(ListForecastsIterable.this.firstRequest);
            }
            return ListForecastsIterable.this.client.listForecasts((ListForecastsRequest)((Object)ListForecastsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

