/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWhatIfForecastsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListWhatIfForecastsResponse.Builder, ListWhatIfForecastsResponse> {
    private static final SdkField<List<WhatIfForecastSummary>> WHAT_IF_FORECASTS_FIELD = SdkField
            .<List<WhatIfForecastSummary>> builder(MarshallingType.LIST)
            .memberName("WhatIfForecasts")
            .getter(getter(ListWhatIfForecastsResponse::whatIfForecasts))
            .setter(setter(Builder::whatIfForecasts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecasts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WhatIfForecastSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WhatIfForecastSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWhatIfForecastsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_FORECASTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<WhatIfForecastSummary> whatIfForecasts;

    private final String nextToken;

    private ListWhatIfForecastsResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfForecasts = builder.whatIfForecasts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WhatIfForecasts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWhatIfForecasts() {
        return whatIfForecasts != null && !(whatIfForecasts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>WhatIfForecasts</code> objects that describe the matched forecasts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWhatIfForecasts} method.
     * </p>
     * 
     * @return An array of <code>WhatIfForecasts</code> objects that describe the matched forecasts.
     */
    public final List<WhatIfForecastSummary> whatIfForecasts() {
        return whatIfForecasts;
    }

    /**
     * <p>
     * If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve
     * the next set of results, use the token in the next&#x2028; request. Tokens expire after 24 hours.
     * </p>
     * 
     * @return If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To
     *         retrieve the next set of results, use the token in the next&#x2028; request. Tokens expire after 24
     *         hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWhatIfForecasts() ? whatIfForecasts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWhatIfForecastsResponse)) {
            return false;
        }
        ListWhatIfForecastsResponse other = (ListWhatIfForecastsResponse) obj;
        return hasWhatIfForecasts() == other.hasWhatIfForecasts() && Objects.equals(whatIfForecasts(), other.whatIfForecasts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWhatIfForecastsResponse")
                .add("WhatIfForecasts", hasWhatIfForecasts() ? whatIfForecasts() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecasts":
            return Optional.ofNullable(clazz.cast(whatIfForecasts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWhatIfForecastsResponse, T> g) {
        return obj -> g.apply((ListWhatIfForecastsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWhatIfForecastsResponse> {
        /**
         * <p>
         * An array of <code>WhatIfForecasts</code> objects that describe the matched forecasts.
         * </p>
         * 
         * @param whatIfForecasts
         *        An array of <code>WhatIfForecasts</code> objects that describe the matched forecasts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecasts(Collection<WhatIfForecastSummary> whatIfForecasts);

        /**
         * <p>
         * An array of <code>WhatIfForecasts</code> objects that describe the matched forecasts.
         * </p>
         * 
         * @param whatIfForecasts
         *        An array of <code>WhatIfForecasts</code> objects that describe the matched forecasts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecasts(WhatIfForecastSummary... whatIfForecasts);

        /**
         * <p>
         * An array of <code>WhatIfForecasts</code> objects that describe the matched forecasts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #whatIfForecasts(List<WhatIfForecastSummary>)}.
         * 
         * @param whatIfForecasts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #whatIfForecasts(java.util.Collection<WhatIfForecastSummary>)
         */
        Builder whatIfForecasts(Consumer<WhatIfForecastSummary.Builder>... whatIfForecasts);

        /**
         * <p>
         * If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To
         * retrieve the next set of results, use the token in the next&#x2028; request. Tokens expire after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous request was truncated, the response includes a <code>NextToken</code>.
         *        To retrieve the next set of results, use the token in the next&#x2028; request. Tokens expire after 24
         *        hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<WhatIfForecastSummary> whatIfForecasts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWhatIfForecastsResponse model) {
            super(model);
            whatIfForecasts(model.whatIfForecasts);
            nextToken(model.nextToken);
        }

        public final List<WhatIfForecastSummary.Builder> getWhatIfForecasts() {
            List<WhatIfForecastSummary.Builder> result = WhatIfForecastsCopier.copyToBuilder(this.whatIfForecasts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWhatIfForecasts(Collection<WhatIfForecastSummary.BuilderImpl> whatIfForecasts) {
            this.whatIfForecasts = WhatIfForecastsCopier.copyFromBuilder(whatIfForecasts);
        }

        @Override
        public final Builder whatIfForecasts(Collection<WhatIfForecastSummary> whatIfForecasts) {
            this.whatIfForecasts = WhatIfForecastsCopier.copy(whatIfForecasts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecasts(WhatIfForecastSummary... whatIfForecasts) {
            whatIfForecasts(Arrays.asList(whatIfForecasts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecasts(Consumer<WhatIfForecastSummary.Builder>... whatIfForecasts) {
            whatIfForecasts(Stream.of(whatIfForecasts).map(c -> WhatIfForecastSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWhatIfForecastsResponse build() {
            return new ListWhatIfForecastsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
