/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ExplainabilityConfig data type defines the number of time series and time points included in
 * <a>CreateExplainability</a>.
 * </p>
 * <p>
 * If you provide a predictor ARN for <code>ResourceArn</code>, you must set both <code>TimePointGranularity</code> and
 * <code>TimeSeriesGranularity</code> to “ALL”. When creating Predictor Explainability, Amazon Forecast considers all
 * time series and time points.
 * </p>
 * <p>
 * If you provide a forecast ARN for <code>ResourceArn</code>, you can set <code>TimePointGranularity</code> and
 * <code>TimeSeriesGranularity</code> to either “ALL” or “Specific”.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExplainabilityConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ExplainabilityConfig.Builder, ExplainabilityConfig> {
    private static final SdkField<String> TIME_SERIES_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeSeriesGranularity").getter(getter(ExplainabilityConfig::timeSeriesGranularityAsString))
            .setter(setter(Builder::timeSeriesGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesGranularity").build())
            .build();

    private static final SdkField<String> TIME_POINT_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimePointGranularity").getter(getter(ExplainabilityConfig::timePointGranularityAsString))
            .setter(setter(Builder::timePointGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePointGranularity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_GRANULARITY_FIELD,
            TIME_POINT_GRANULARITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeSeriesGranularity;

    private final String timePointGranularity;

    private ExplainabilityConfig(BuilderImpl builder) {
        this.timeSeriesGranularity = builder.timeSeriesGranularity;
        this.timePointGranularity = builder.timePointGranularity;
    }

    /**
     * <p>
     * To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
     * Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.
     * </p>
     * <p>
     * Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within the
     * <a>DataDestination</a> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timeSeriesGranularity} will return {@link TimeSeriesGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timeSeriesGranularityAsString}.
     * </p>
     * 
     * @return To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
     *         Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
     *         <p>
     *         Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within
     *         the <a>DataDestination</a> data type.
     * @see TimeSeriesGranularity
     */
    public final TimeSeriesGranularity timeSeriesGranularity() {
        return TimeSeriesGranularity.fromValue(timeSeriesGranularity);
    }

    /**
     * <p>
     * To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
     * Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.
     * </p>
     * <p>
     * Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within the
     * <a>DataDestination</a> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timeSeriesGranularity} will return {@link TimeSeriesGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timeSeriesGranularityAsString}.
     * </p>
     * 
     * @return To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
     *         Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
     *         <p>
     *         Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within
     *         the <a>DataDestination</a> data type.
     * @see TimeSeriesGranularity
     */
    public final String timeSeriesGranularityAsString() {
        return timeSeriesGranularity;
    }

    /**
     * <p>
     * To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an
     * Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.
     * </p>
     * <p>
     * Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the
     * <a>CreateExplainability</a> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timePointGranularity} will return {@link TimePointGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timePointGranularityAsString}.
     * </p>
     * 
     * @return To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create
     *         an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.</p>
     *         <p>
     *         Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within
     *         the <a>CreateExplainability</a> operation.
     * @see TimePointGranularity
     */
    public final TimePointGranularity timePointGranularity() {
        return TimePointGranularity.fromValue(timePointGranularity);
    }

    /**
     * <p>
     * To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an
     * Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.
     * </p>
     * <p>
     * Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the
     * <a>CreateExplainability</a> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timePointGranularity} will return {@link TimePointGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timePointGranularityAsString}.
     * </p>
     * 
     * @return To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create
     *         an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.</p>
     *         <p>
     *         Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within
     *         the <a>CreateExplainability</a> operation.
     * @see TimePointGranularity
     */
    public final String timePointGranularityAsString() {
        return timePointGranularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timePointGranularityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExplainabilityConfig)) {
            return false;
        }
        ExplainabilityConfig other = (ExplainabilityConfig) obj;
        return Objects.equals(timeSeriesGranularityAsString(), other.timeSeriesGranularityAsString())
                && Objects.equals(timePointGranularityAsString(), other.timePointGranularityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExplainabilityConfig").add("TimeSeriesGranularity", timeSeriesGranularityAsString())
                .add("TimePointGranularity", timePointGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeSeriesGranularity":
            return Optional.ofNullable(clazz.cast(timeSeriesGranularityAsString()));
        case "TimePointGranularity":
            return Optional.ofNullable(clazz.cast(timePointGranularityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExplainabilityConfig, T> g) {
        return obj -> g.apply((ExplainabilityConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExplainabilityConfig> {
        /**
         * <p>
         * To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
         * Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.
         * </p>
         * <p>
         * Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within the
         * <a>DataDestination</a> data type.
         * </p>
         * 
         * @param timeSeriesGranularity
         *        To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
         *        Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
         *        <p>
         *        Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location
         *        within the <a>DataDestination</a> data type.
         * @see TimeSeriesGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesGranularity
         */
        Builder timeSeriesGranularity(String timeSeriesGranularity);

        /**
         * <p>
         * To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
         * Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.
         * </p>
         * <p>
         * Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within the
         * <a>DataDestination</a> data type.
         * </p>
         * 
         * @param timeSeriesGranularity
         *        To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an
         *        Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
         *        <p>
         *        Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location
         *        within the <a>DataDestination</a> data type.
         * @see TimeSeriesGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesGranularity
         */
        Builder timeSeriesGranularity(TimeSeriesGranularity timeSeriesGranularity);

        /**
         * <p>
         * To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an
         * Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.
         * </p>
         * <p>
         * Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the
         * <a>CreateExplainability</a> operation.
         * </p>
         * 
         * @param timePointGranularity
         *        To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To
         *        create an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>
         *        .</p>
         *        <p>
         *        Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within
         *        the <a>CreateExplainability</a> operation.
         * @see TimePointGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimePointGranularity
         */
        Builder timePointGranularity(String timePointGranularity);

        /**
         * <p>
         * To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an
         * Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.
         * </p>
         * <p>
         * Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the
         * <a>CreateExplainability</a> operation.
         * </p>
         * 
         * @param timePointGranularity
         *        To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To
         *        create an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>
         *        .</p>
         *        <p>
         *        Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within
         *        the <a>CreateExplainability</a> operation.
         * @see TimePointGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimePointGranularity
         */
        Builder timePointGranularity(TimePointGranularity timePointGranularity);
    }

    static final class BuilderImpl implements Builder {
        private String timeSeriesGranularity;

        private String timePointGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(ExplainabilityConfig model) {
            timeSeriesGranularity(model.timeSeriesGranularity);
            timePointGranularity(model.timePointGranularity);
        }

        public final String getTimeSeriesGranularity() {
            return timeSeriesGranularity;
        }

        public final void setTimeSeriesGranularity(String timeSeriesGranularity) {
            this.timeSeriesGranularity = timeSeriesGranularity;
        }

        @Override
        public final Builder timeSeriesGranularity(String timeSeriesGranularity) {
            this.timeSeriesGranularity = timeSeriesGranularity;
            return this;
        }

        @Override
        public final Builder timeSeriesGranularity(TimeSeriesGranularity timeSeriesGranularity) {
            this.timeSeriesGranularity(timeSeriesGranularity == null ? null : timeSeriesGranularity.toString());
            return this;
        }

        public final String getTimePointGranularity() {
            return timePointGranularity;
        }

        public final void setTimePointGranularity(String timePointGranularity) {
            this.timePointGranularity = timePointGranularity;
        }

        @Override
        public final Builder timePointGranularity(String timePointGranularity) {
            this.timePointGranularity = timePointGranularity;
            return this;
        }

        @Override
        public final Builder timePointGranularity(TimePointGranularity timePointGranularity) {
            this.timePointGranularity(timePointGranularity == null ? null : timePointGranularity.toString());
            return this;
        }

        @Override
        public ExplainabilityConfig build() {
            return new ExplainabilityConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
