/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse;
import software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation;

public class ListMonitorEvaluationsIterable
implements SdkIterable<ListMonitorEvaluationsResponse> {
    private final ForecastClient client;
    private final ListMonitorEvaluationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMonitorEvaluationsIterable(ForecastClient client, ListMonitorEvaluationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMonitorEvaluationsResponseFetcher();
    }

    public Iterator<ListMonitorEvaluationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PredictorMonitorEvaluation> predictorMonitorEvaluations() {
        Function<ListMonitorEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.predictorMonitorEvaluations() != null) {
                return response.predictorMonitorEvaluations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMonitorEvaluationsResponseFetcher
    implements SyncPageFetcher<ListMonitorEvaluationsResponse> {
        private ListMonitorEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitorEvaluationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMonitorEvaluationsResponse nextPage(ListMonitorEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitorEvaluationsIterable.this.client.listMonitorEvaluations(ListMonitorEvaluationsIterable.this.firstRequest);
            }
            return ListMonitorEvaluationsIterable.this.client.listMonitorEvaluations((ListMonitorEvaluationsRequest)((Object)ListMonitorEvaluationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

