/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.DataSource;
import software.amazon.awssdk.services.forecast.model.ExplainabilityConfig;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.Schema;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExplainabilityRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateExplainabilityRequest> {
    private static final SdkField<String> EXPLAINABILITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityName").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::explainabilityName)).setter(CreateExplainabilityRequest.setter(Builder::explainabilityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::resourceArn)).setter(CreateExplainabilityRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<ExplainabilityConfig> EXPLAINABILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExplainabilityConfig").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::explainabilityConfig)).setter(CreateExplainabilityRequest.setter(Builder::explainabilityConfig)).constructor(ExplainabilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityConfig").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::dataSource)).setter(CreateExplainabilityRequest.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schema").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::schema)).setter(CreateExplainabilityRequest.setter(Builder::schema)).constructor(Schema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<Boolean> ENABLE_VISUALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableVisualization").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::enableVisualization)).setter(CreateExplainabilityRequest.setter(Builder::enableVisualization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableVisualization").build()}).build();
    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartDateTime").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::startDateTime)).setter(CreateExplainabilityRequest.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()}).build();
    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDateTime").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::endDateTime)).setter(CreateExplainabilityRequest.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateExplainabilityRequest.getter(CreateExplainabilityRequest::tags)).setter(CreateExplainabilityRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_NAME_FIELD, RESOURCE_ARN_FIELD, EXPLAINABILITY_CONFIG_FIELD, DATA_SOURCE_FIELD, SCHEMA_FIELD, ENABLE_VISUALIZATION_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, TAGS_FIELD));
    private final String explainabilityName;
    private final String resourceArn;
    private final ExplainabilityConfig explainabilityConfig;
    private final DataSource dataSource;
    private final Schema schema;
    private final Boolean enableVisualization;
    private final String startDateTime;
    private final String endDateTime;
    private final List<Tag> tags;

    private CreateExplainabilityRequest(BuilderImpl builder) {
        super(builder);
        this.explainabilityName = builder.explainabilityName;
        this.resourceArn = builder.resourceArn;
        this.explainabilityConfig = builder.explainabilityConfig;
        this.dataSource = builder.dataSource;
        this.schema = builder.schema;
        this.enableVisualization = builder.enableVisualization;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.tags = builder.tags;
    }

    public final String explainabilityName() {
        return this.explainabilityName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ExplainabilityConfig explainabilityConfig() {
        return this.explainabilityConfig;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final Schema schema() {
        return this.schema;
    }

    public final Boolean enableVisualization() {
        return this.enableVisualization;
    }

    public final String startDateTime() {
        return this.startDateTime;
    }

    public final String endDateTime() {
        return this.endDateTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableVisualization());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExplainabilityRequest)) {
            return false;
        }
        CreateExplainabilityRequest other = (CreateExplainabilityRequest)((Object)obj);
        return Objects.equals(this.explainabilityName(), other.explainabilityName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.explainabilityConfig(), other.explainabilityConfig()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.enableVisualization(), other.enableVisualization()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExplainabilityRequest").add("ExplainabilityName", (Object)this.explainabilityName()).add("ResourceArn", (Object)this.resourceArn()).add("ExplainabilityConfig", (Object)this.explainabilityConfig()).add("DataSource", (Object)this.dataSource()).add("Schema", (Object)this.schema()).add("EnableVisualization", (Object)this.enableVisualization()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExplainabilityName": {
                return Optional.ofNullable(clazz.cast(this.explainabilityName()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ExplainabilityConfig": {
                return Optional.ofNullable(clazz.cast(this.explainabilityConfig()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "EnableVisualization": {
                return Optional.ofNullable(clazz.cast(this.enableVisualization()));
            }
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "EndDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExplainabilityRequest, T> g) {
        return obj -> g.apply((CreateExplainabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String explainabilityName;
        private String resourceArn;
        private ExplainabilityConfig explainabilityConfig;
        private DataSource dataSource;
        private Schema schema;
        private Boolean enableVisualization;
        private String startDateTime;
        private String endDateTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExplainabilityRequest model) {
            super(model);
            this.explainabilityName(model.explainabilityName);
            this.resourceArn(model.resourceArn);
            this.explainabilityConfig(model.explainabilityConfig);
            this.dataSource(model.dataSource);
            this.schema(model.schema);
            this.enableVisualization(model.enableVisualization);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.tags(model.tags);
        }

        public final String getExplainabilityName() {
            return this.explainabilityName;
        }

        public final void setExplainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
        }

        @Override
        @Transient
        public final Builder explainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ExplainabilityConfig.Builder getExplainabilityConfig() {
            return this.explainabilityConfig != null ? this.explainabilityConfig.toBuilder() : null;
        }

        public final void setExplainabilityConfig(ExplainabilityConfig.BuilderImpl explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig != null ? explainabilityConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        @Transient
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Schema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        @Transient
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final Boolean getEnableVisualization() {
            return this.enableVisualization;
        }

        public final void setEnableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
        }

        @Override
        @Transient
        public final Builder enableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
            return this;
        }

        public final String getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        @Transient
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        @Transient
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExplainabilityRequest build() {
            return new CreateExplainabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExplainabilityRequest> {
        public Builder explainabilityName(String var1);

        public Builder resourceArn(String var1);

        public Builder explainabilityConfig(ExplainabilityConfig var1);

        default public Builder explainabilityConfig(Consumer<ExplainabilityConfig.Builder> explainabilityConfig) {
            return this.explainabilityConfig((ExplainabilityConfig)((ExplainabilityConfig.Builder)ExplainabilityConfig.builder().applyMutation(explainabilityConfig)).build());
        }

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder schema(Schema var1);

        default public Builder schema(Consumer<Schema.Builder> schema) {
            return this.schema((Schema)((Schema.Builder)Schema.builder().applyMutation(schema)).build());
        }

        public Builder enableVisualization(Boolean var1);

        public Builder startDateTime(String var1);

        public Builder endDateTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

