/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary;
import software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPredictorBacktestExportJobsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListPredictorBacktestExportJobsResponse> {
    private static final SdkField<List<PredictorBacktestExportJobSummary>> PREDICTOR_BACKTEST_EXPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredictorBacktestExportJobs").getter(ListPredictorBacktestExportJobsResponse.getter(ListPredictorBacktestExportJobsResponse::predictorBacktestExportJobs)).setter(ListPredictorBacktestExportJobsResponse.setter(Builder::predictorBacktestExportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBacktestExportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictorBacktestExportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPredictorBacktestExportJobsResponse.getter(ListPredictorBacktestExportJobsResponse::nextToken)).setter(ListPredictorBacktestExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_BACKTEST_EXPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PredictorBacktestExportJobSummary> predictorBacktestExportJobs;
    private final String nextToken;

    private ListPredictorBacktestExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.predictorBacktestExportJobs = builder.predictorBacktestExportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPredictorBacktestExportJobs() {
        return this.predictorBacktestExportJobs != null && !(this.predictorBacktestExportJobs instanceof SdkAutoConstructList);
    }

    public final List<PredictorBacktestExportJobSummary> predictorBacktestExportJobs() {
        return this.predictorBacktestExportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredictorBacktestExportJobs() ? this.predictorBacktestExportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPredictorBacktestExportJobsResponse)) {
            return false;
        }
        ListPredictorBacktestExportJobsResponse other = (ListPredictorBacktestExportJobsResponse)((Object)obj);
        return this.hasPredictorBacktestExportJobs() == other.hasPredictorBacktestExportJobs() && Objects.equals(this.predictorBacktestExportJobs(), other.predictorBacktestExportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPredictorBacktestExportJobsResponse").add("PredictorBacktestExportJobs", this.hasPredictorBacktestExportJobs() ? this.predictorBacktestExportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorBacktestExportJobs": {
                return Optional.ofNullable(clazz.cast(this.predictorBacktestExportJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPredictorBacktestExportJobsResponse, T> g) {
        return obj -> g.apply((ListPredictorBacktestExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<PredictorBacktestExportJobSummary> predictorBacktestExportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPredictorBacktestExportJobsResponse model) {
            super(model);
            this.predictorBacktestExportJobs(model.predictorBacktestExportJobs);
            this.nextToken(model.nextToken);
        }

        public final List<PredictorBacktestExportJobSummary.Builder> getPredictorBacktestExportJobs() {
            List<PredictorBacktestExportJobSummary.Builder> result = PredictorBacktestExportJobsCopier.copyToBuilder(this.predictorBacktestExportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredictorBacktestExportJobs(Collection<PredictorBacktestExportJobSummary.BuilderImpl> predictorBacktestExportJobs) {
            this.predictorBacktestExportJobs = PredictorBacktestExportJobsCopier.copyFromBuilder(predictorBacktestExportJobs);
        }

        @Override
        @Transient
        public final Builder predictorBacktestExportJobs(Collection<PredictorBacktestExportJobSummary> predictorBacktestExportJobs) {
            this.predictorBacktestExportJobs = PredictorBacktestExportJobsCopier.copy(predictorBacktestExportJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder predictorBacktestExportJobs(PredictorBacktestExportJobSummary ... predictorBacktestExportJobs) {
            this.predictorBacktestExportJobs(Arrays.asList(predictorBacktestExportJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder predictorBacktestExportJobs(Consumer<PredictorBacktestExportJobSummary.Builder> ... predictorBacktestExportJobs) {
            this.predictorBacktestExportJobs(Stream.of(predictorBacktestExportJobs).map(c -> (PredictorBacktestExportJobSummary)((PredictorBacktestExportJobSummary.Builder)PredictorBacktestExportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPredictorBacktestExportJobsResponse build() {
            return new ListPredictorBacktestExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPredictorBacktestExportJobsResponse> {
        public Builder predictorBacktestExportJobs(Collection<PredictorBacktestExportJobSummary> var1);

        public Builder predictorBacktestExportJobs(PredictorBacktestExportJobSummary ... var1);

        public Builder predictorBacktestExportJobs(Consumer<PredictorBacktestExportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

