/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AutoMLOverrideStrategy {
    LATENCY_OPTIMIZED("LatencyOptimized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AutoMLOverrideStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLOverrideStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AutoMLOverrideStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLOverrideStrategy> knownValues() {
        return Stream.of(AutoMLOverrideStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

