/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse;
import software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary;

public class ListPredictorBacktestExportJobsPublisher
implements SdkPublisher<ListPredictorBacktestExportJobsResponse> {
    private final ForecastAsyncClient client;
    private final ListPredictorBacktestExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPredictorBacktestExportJobsPublisher(ForecastAsyncClient client, ListPredictorBacktestExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPredictorBacktestExportJobsPublisher(ForecastAsyncClient client, ListPredictorBacktestExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPredictorBacktestExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPredictorBacktestExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PredictorBacktestExportJobSummary> predictorBacktestExportJobs() {
        Function<ListPredictorBacktestExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.predictorBacktestExportJobs() != null) {
                return response.predictorBacktestExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPredictorBacktestExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPredictorBacktestExportJobsResponseFetcher
    implements AsyncPageFetcher<ListPredictorBacktestExportJobsResponse> {
        private ListPredictorBacktestExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListPredictorBacktestExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPredictorBacktestExportJobsResponse> nextPage(ListPredictorBacktestExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListPredictorBacktestExportJobsPublisher.this.client.listPredictorBacktestExportJobs(ListPredictorBacktestExportJobsPublisher.this.firstRequest);
            }
            return ListPredictorBacktestExportJobsPublisher.this.client.listPredictorBacktestExportJobs((ListPredictorBacktestExportJobsRequest)((Object)ListPredictorBacktestExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

