/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.model.ForecastSummary;
import software.amazon.awssdk.services.forecast.model.ListForecastsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastsResponse;

public class ListForecastsPublisher
implements SdkPublisher<ListForecastsResponse> {
    private final ForecastAsyncClient client;
    private final ListForecastsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListForecastsPublisher(ForecastAsyncClient client, ListForecastsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListForecastsPublisher(ForecastAsyncClient client, ListForecastsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListForecastsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListForecastsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ForecastSummary> forecasts() {
        Function<ListForecastsResponse, Iterator> getIterator = response -> {
            if (response != null && response.forecasts() != null) {
                return response.forecasts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListForecastsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListForecastsResponseFetcher
    implements AsyncPageFetcher<ListForecastsResponse> {
        private ListForecastsResponseFetcher() {
        }

        public boolean hasNextPage(ListForecastsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListForecastsResponse> nextPage(ListForecastsResponse previousPage) {
            if (previousPage == null) {
                return ListForecastsPublisher.this.client.listForecasts(ListForecastsPublisher.this.firstRequest);
            }
            return ListForecastsPublisher.this.client.listForecasts((ListForecastsRequest)((Object)ListForecastsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

