/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.model.ListPredictorsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorsResponse;
import software.amazon.awssdk.services.forecast.model.PredictorSummary;

public class ListPredictorsIterable
implements SdkIterable<ListPredictorsResponse> {
    private final ForecastClient client;
    private final ListPredictorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPredictorsIterable(ForecastClient client, ListPredictorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPredictorsResponseFetcher();
    }

    public Iterator<ListPredictorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PredictorSummary> predictors() {
        Function<ListPredictorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.predictors() != null) {
                return response.predictors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPredictorsResponseFetcher
    implements SyncPageFetcher<ListPredictorsResponse> {
        private ListPredictorsResponseFetcher() {
        }

        public boolean hasNextPage(ListPredictorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPredictorsResponse nextPage(ListPredictorsResponse previousPage) {
            if (previousPage == null) {
                return ListPredictorsIterable.this.client.listPredictors(ListPredictorsIterable.this.firstRequest);
            }
            return ListPredictorsIterable.this.client.listPredictors((ListPredictorsRequest)((Object)ListPredictorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

