/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.EvaluationResult;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.PredictorEvaluationResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccuracyMetricsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, GetAccuracyMetricsResponse> {
    private static final SdkField<List<EvaluationResult>> PREDICTOR_EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredictorEvaluationResults").getter(GetAccuracyMetricsResponse.getter(GetAccuracyMetricsResponse::predictorEvaluationResults)).setter(GetAccuracyMetricsResponse.setter(Builder::predictorEvaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorEvaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_EVALUATION_RESULTS_FIELD));
    private final List<EvaluationResult> predictorEvaluationResults;

    private GetAccuracyMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.predictorEvaluationResults = builder.predictorEvaluationResults;
    }

    public final boolean hasPredictorEvaluationResults() {
        return this.predictorEvaluationResults != null && !(this.predictorEvaluationResults instanceof SdkAutoConstructList);
    }

    public final List<EvaluationResult> predictorEvaluationResults() {
        return this.predictorEvaluationResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredictorEvaluationResults() ? this.predictorEvaluationResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccuracyMetricsResponse)) {
            return false;
        }
        GetAccuracyMetricsResponse other = (GetAccuracyMetricsResponse)((Object)obj);
        return this.hasPredictorEvaluationResults() == other.hasPredictorEvaluationResults() && Objects.equals(this.predictorEvaluationResults(), other.predictorEvaluationResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccuracyMetricsResponse").add("PredictorEvaluationResults", this.hasPredictorEvaluationResults() ? this.predictorEvaluationResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorEvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.predictorEvaluationResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccuracyMetricsResponse, T> g) {
        return obj -> g.apply((GetAccuracyMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResult> predictorEvaluationResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccuracyMetricsResponse model) {
            super(model);
            this.predictorEvaluationResults(model.predictorEvaluationResults);
        }

        public final List<EvaluationResult.Builder> getPredictorEvaluationResults() {
            List<EvaluationResult.Builder> result = PredictorEvaluationResultsCopier.copyToBuilder(this.predictorEvaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder predictorEvaluationResults(Collection<EvaluationResult> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copy(predictorEvaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorEvaluationResults(EvaluationResult ... predictorEvaluationResults) {
            this.predictorEvaluationResults(Arrays.asList(predictorEvaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder> ... predictorEvaluationResults) {
            this.predictorEvaluationResults(Stream.of(predictorEvaluationResults).map(c -> (EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPredictorEvaluationResults(Collection<EvaluationResult.BuilderImpl> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copyFromBuilder(predictorEvaluationResults);
        }

        @Override
        public GetAccuracyMetricsResponse build() {
            return new GetAccuracyMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccuracyMetricsResponse> {
        public Builder predictorEvaluationResults(Collection<EvaluationResult> var1);

        public Builder predictorEvaluationResults(EvaluationResult ... var1);

        public Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder> ... var1);
    }
}

