/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.FeaturizationMethod;
import software.amazon.awssdk.services.forecast.model.FeaturizationPipelineCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Featurization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Featurization> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(Featurization.getter(Featurization::attributeName)).setter(Featurization.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<FeaturizationMethod>> FEATURIZATION_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeaturizationPipeline").getter(Featurization.getter(Featurization::featurizationPipeline)).setter(Featurization.setter(Builder::featurizationPipeline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationPipeline").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeaturizationMethod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, FEATURIZATION_PIPELINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final List<FeaturizationMethod> featurizationPipeline;

    private Featurization(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.featurizationPipeline = builder.featurizationPipeline;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasFeaturizationPipeline() {
        return this.featurizationPipeline != null && !(this.featurizationPipeline instanceof SdkAutoConstructList);
    }

    public final List<FeaturizationMethod> featurizationPipeline() {
        return this.featurizationPipeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeaturizationPipeline() ? this.featurizationPipeline() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Featurization)) {
            return false;
        }
        Featurization other = (Featurization)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && this.hasFeaturizationPipeline() == other.hasFeaturizationPipeline() && Objects.equals(this.featurizationPipeline(), other.featurizationPipeline());
    }

    public final String toString() {
        return ToString.builder((String)"Featurization").add("AttributeName", (Object)this.attributeName()).add("FeaturizationPipeline", this.hasFeaturizationPipeline() ? this.featurizationPipeline() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "FeaturizationPipeline": {
                return Optional.ofNullable(clazz.cast(this.featurizationPipeline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Featurization, T> g) {
        return obj -> g.apply((Featurization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private List<FeaturizationMethod> featurizationPipeline = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Featurization model) {
            this.attributeName(model.attributeName);
            this.featurizationPipeline(model.featurizationPipeline);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final List<FeaturizationMethod.Builder> getFeaturizationPipeline() {
            List<FeaturizationMethod.Builder> result = FeaturizationPipelineCopier.copyToBuilder(this.featurizationPipeline);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder featurizationPipeline(Collection<FeaturizationMethod> featurizationPipeline) {
            this.featurizationPipeline = FeaturizationPipelineCopier.copy(featurizationPipeline);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featurizationPipeline(FeaturizationMethod ... featurizationPipeline) {
            this.featurizationPipeline(Arrays.asList(featurizationPipeline));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featurizationPipeline(Consumer<FeaturizationMethod.Builder> ... featurizationPipeline) {
            this.featurizationPipeline(Stream.of(featurizationPipeline).map(c -> (FeaturizationMethod)((FeaturizationMethod.Builder)FeaturizationMethod.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFeaturizationPipeline(Collection<FeaturizationMethod.BuilderImpl> featurizationPipeline) {
            this.featurizationPipeline = FeaturizationPipelineCopier.copyFromBuilder(featurizationPipeline);
        }

        public Featurization build() {
            return new Featurization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Featurization> {
        public Builder attributeName(String var1);

        public Builder featurizationPipeline(Collection<FeaturizationMethod> var1);

        public Builder featurizationPipeline(FeaturizationMethod ... var1);

        public Builder featurizationPipeline(Consumer<FeaturizationMethod.Builder> ... var1);
    }
}

