/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ErrorMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ErrorMetric> {
    private static final SdkField<String> FORECAST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastType").getter(ErrorMetric.getter(ErrorMetric::forecastType)).setter(ErrorMetric.setter(Builder::forecastType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastType").build()}).build();
    private static final SdkField<Double> WAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("WAPE").getter(ErrorMetric.getter(ErrorMetric::wape)).setter(ErrorMetric.setter(Builder::wape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WAPE").build()}).build();
    private static final SdkField<Double> RMSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("RMSE").getter(ErrorMetric.getter(ErrorMetric::rmse)).setter(ErrorMetric.setter(Builder::rmse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RMSE").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_TYPE_FIELD, WAPE_FIELD, RMSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String forecastType;
    private final Double wape;
    private final Double rmse;

    private ErrorMetric(BuilderImpl builder) {
        this.forecastType = builder.forecastType;
        this.wape = builder.wape;
        this.rmse = builder.rmse;
    }

    public final String forecastType() {
        return this.forecastType;
    }

    public final Double wape() {
        return this.wape;
    }

    public final Double rmse() {
        return this.rmse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastType());
        hashCode = 31 * hashCode + Objects.hashCode(this.wape());
        hashCode = 31 * hashCode + Objects.hashCode(this.rmse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorMetric)) {
            return false;
        }
        ErrorMetric other = (ErrorMetric)obj;
        return Objects.equals(this.forecastType(), other.forecastType()) && Objects.equals(this.wape(), other.wape()) && Objects.equals(this.rmse(), other.rmse());
    }

    public final String toString() {
        return ToString.builder((String)"ErrorMetric").add("ForecastType", (Object)this.forecastType()).add("WAPE", (Object)this.wape()).add("RMSE", (Object)this.rmse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastType": {
                return Optional.ofNullable(clazz.cast(this.forecastType()));
            }
            case "WAPE": {
                return Optional.ofNullable(clazz.cast(this.wape()));
            }
            case "RMSE": {
                return Optional.ofNullable(clazz.cast(this.rmse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorMetric, T> g) {
        return obj -> g.apply((ErrorMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String forecastType;
        private Double wape;
        private Double rmse;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorMetric model) {
            this.forecastType(model.forecastType);
            this.wape(model.wape);
            this.rmse(model.rmse);
        }

        public final String getForecastType() {
            return this.forecastType;
        }

        @Override
        public final Builder forecastType(String forecastType) {
            this.forecastType = forecastType;
            return this;
        }

        public final void setForecastType(String forecastType) {
            this.forecastType = forecastType;
        }

        public final Double getWape() {
            return this.wape;
        }

        @Override
        public final Builder wape(Double wape) {
            this.wape = wape;
            return this;
        }

        public final void setWape(Double wape) {
            this.wape = wape;
        }

        public final Double getRmse() {
            return this.rmse;
        }

        @Override
        public final Builder rmse(Double rmse) {
            this.rmse = rmse;
            return this;
        }

        public final void setRmse(Double rmse) {
            this.rmse = rmse;
        }

        public ErrorMetric build() {
            return new ErrorMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ErrorMetric> {
        public Builder forecastType(String var1);

        public Builder wape(Double var1);

        public Builder rmse(Double var1);
    }
}

