/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy;
import software.amazon.awssdk.services.forecast.model.EncryptionConfig;
import software.amazon.awssdk.services.forecast.model.EvaluationParameters;
import software.amazon.awssdk.services.forecast.model.FeaturizationConfig;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.ForecastTypesCopier;
import software.amazon.awssdk.services.forecast.model.HyperParameterTuningJobConfig;
import software.amazon.awssdk.services.forecast.model.InputDataConfig;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.services.forecast.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePredictorRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreatePredictorRequest> {
    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorName").getter(CreatePredictorRequest.getter(CreatePredictorRequest::predictorName)).setter(CreatePredictorRequest.setter(Builder::predictorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()}).build();
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmArn").getter(CreatePredictorRequest.getter(CreatePredictorRequest::algorithmArn)).setter(CreatePredictorRequest.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()}).build();
    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ForecastHorizon").getter(CreatePredictorRequest.getter(CreatePredictorRequest::forecastHorizon)).setter(CreatePredictorRequest.setter(Builder::forecastHorizon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()}).build();
    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastTypes").getter(CreatePredictorRequest.getter(CreatePredictorRequest::forecastTypes)).setter(CreatePredictorRequest.setter(Builder::forecastTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformAutoML").getter(CreatePredictorRequest.getter(CreatePredictorRequest::performAutoML)).setter(CreatePredictorRequest.setter(Builder::performAutoML)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformAutoML").build()}).build();
    private static final SdkField<String> AUTO_ML_OVERRIDE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLOverrideStrategy").getter(CreatePredictorRequest.getter(CreatePredictorRequest::autoMLOverrideStrategyAsString)).setter(CreatePredictorRequest.setter(Builder::autoMLOverrideStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLOverrideStrategy").build()}).build();
    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformHPO").getter(CreatePredictorRequest.getter(CreatePredictorRequest::performHPO)).setter(CreatePredictorRequest.setter(Builder::performHPO)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformHPO").build()}).build();
    private static final SdkField<Map<String, String>> TRAINING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TrainingParameters").getter(CreatePredictorRequest.getter(CreatePredictorRequest::trainingParameters)).setter(CreatePredictorRequest.setter(Builder::trainingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EvaluationParameters> EVALUATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationParameters").getter(CreatePredictorRequest.getter(CreatePredictorRequest::evaluationParameters)).setter(CreatePredictorRequest.setter(Builder::evaluationParameters)).constructor(EvaluationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationParameters").build()}).build();
    private static final SdkField<HyperParameterTuningJobConfig> HPO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HPOConfig").getter(CreatePredictorRequest.getter(CreatePredictorRequest::hpoConfig)).setter(CreatePredictorRequest.setter(Builder::hpoConfig)).constructor(HyperParameterTuningJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HPOConfig").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(CreatePredictorRequest.getter(CreatePredictorRequest::inputDataConfig)).setter(CreatePredictorRequest.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<FeaturizationConfig> FEATURIZATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FeaturizationConfig").getter(CreatePredictorRequest.getter(CreatePredictorRequest::featurizationConfig)).setter(CreatePredictorRequest.setter(Builder::featurizationConfig)).constructor(FeaturizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationConfig").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfig").getter(CreatePredictorRequest.getter(CreatePredictorRequest::encryptionConfig)).setter(CreatePredictorRequest.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePredictorRequest.getter(CreatePredictorRequest::tags)).setter(CreatePredictorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_NAME_FIELD, ALGORITHM_ARN_FIELD, FORECAST_HORIZON_FIELD, FORECAST_TYPES_FIELD, PERFORM_AUTO_ML_FIELD, AUTO_ML_OVERRIDE_STRATEGY_FIELD, PERFORM_HPO_FIELD, TRAINING_PARAMETERS_FIELD, EVALUATION_PARAMETERS_FIELD, HPO_CONFIG_FIELD, INPUT_DATA_CONFIG_FIELD, FEATURIZATION_CONFIG_FIELD, ENCRYPTION_CONFIG_FIELD, TAGS_FIELD));
    private final String predictorName;
    private final String algorithmArn;
    private final Integer forecastHorizon;
    private final List<String> forecastTypes;
    private final Boolean performAutoML;
    private final String autoMLOverrideStrategy;
    private final Boolean performHPO;
    private final Map<String, String> trainingParameters;
    private final EvaluationParameters evaluationParameters;
    private final HyperParameterTuningJobConfig hpoConfig;
    private final InputDataConfig inputDataConfig;
    private final FeaturizationConfig featurizationConfig;
    private final EncryptionConfig encryptionConfig;
    private final List<Tag> tags;

    private CreatePredictorRequest(BuilderImpl builder) {
        super(builder);
        this.predictorName = builder.predictorName;
        this.algorithmArn = builder.algorithmArn;
        this.forecastHorizon = builder.forecastHorizon;
        this.forecastTypes = builder.forecastTypes;
        this.performAutoML = builder.performAutoML;
        this.autoMLOverrideStrategy = builder.autoMLOverrideStrategy;
        this.performHPO = builder.performHPO;
        this.trainingParameters = builder.trainingParameters;
        this.evaluationParameters = builder.evaluationParameters;
        this.hpoConfig = builder.hpoConfig;
        this.inputDataConfig = builder.inputDataConfig;
        this.featurizationConfig = builder.featurizationConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.tags = builder.tags;
    }

    public final String predictorName() {
        return this.predictorName;
    }

    public final String algorithmArn() {
        return this.algorithmArn;
    }

    public final Integer forecastHorizon() {
        return this.forecastHorizon;
    }

    public final boolean hasForecastTypes() {
        return this.forecastTypes != null && !(this.forecastTypes instanceof SdkAutoConstructList);
    }

    public final List<String> forecastTypes() {
        return this.forecastTypes;
    }

    public final Boolean performAutoML() {
        return this.performAutoML;
    }

    public final AutoMLOverrideStrategy autoMLOverrideStrategy() {
        return AutoMLOverrideStrategy.fromValue(this.autoMLOverrideStrategy);
    }

    public final String autoMLOverrideStrategyAsString() {
        return this.autoMLOverrideStrategy;
    }

    public final Boolean performHPO() {
        return this.performHPO;
    }

    public final boolean hasTrainingParameters() {
        return this.trainingParameters != null && !(this.trainingParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> trainingParameters() {
        return this.trainingParameters;
    }

    public final EvaluationParameters evaluationParameters() {
        return this.evaluationParameters;
    }

    public final HyperParameterTuningJobConfig hpoConfig() {
        return this.hpoConfig;
    }

    public final InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final FeaturizationConfig featurizationConfig() {
        return this.featurizationConfig;
    }

    public final EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastTypes() ? this.forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLOverrideStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingParameters() ? this.trainingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hpoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.featurizationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePredictorRequest)) {
            return false;
        }
        CreatePredictorRequest other = (CreatePredictorRequest)((Object)obj);
        return Objects.equals(this.predictorName(), other.predictorName()) && Objects.equals(this.algorithmArn(), other.algorithmArn()) && Objects.equals(this.forecastHorizon(), other.forecastHorizon()) && this.hasForecastTypes() == other.hasForecastTypes() && Objects.equals(this.forecastTypes(), other.forecastTypes()) && Objects.equals(this.performAutoML(), other.performAutoML()) && Objects.equals(this.autoMLOverrideStrategyAsString(), other.autoMLOverrideStrategyAsString()) && Objects.equals(this.performHPO(), other.performHPO()) && this.hasTrainingParameters() == other.hasTrainingParameters() && Objects.equals(this.trainingParameters(), other.trainingParameters()) && Objects.equals(this.evaluationParameters(), other.evaluationParameters()) && Objects.equals(this.hpoConfig(), other.hpoConfig()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.featurizationConfig(), other.featurizationConfig()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePredictorRequest").add("PredictorName", (Object)this.predictorName()).add("AlgorithmArn", (Object)this.algorithmArn()).add("ForecastHorizon", (Object)this.forecastHorizon()).add("ForecastTypes", this.hasForecastTypes() ? this.forecastTypes() : null).add("PerformAutoML", (Object)this.performAutoML()).add("AutoMLOverrideStrategy", (Object)this.autoMLOverrideStrategyAsString()).add("PerformHPO", (Object)this.performHPO()).add("TrainingParameters", this.hasTrainingParameters() ? this.trainingParameters() : null).add("EvaluationParameters", (Object)this.evaluationParameters()).add("HPOConfig", (Object)this.hpoConfig()).add("InputDataConfig", (Object)this.inputDataConfig()).add("FeaturizationConfig", (Object)this.featurizationConfig()).add("EncryptionConfig", (Object)this.encryptionConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorName": {
                return Optional.ofNullable(clazz.cast(this.predictorName()));
            }
            case "AlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "ForecastHorizon": {
                return Optional.ofNullable(clazz.cast(this.forecastHorizon()));
            }
            case "ForecastTypes": {
                return Optional.ofNullable(clazz.cast(this.forecastTypes()));
            }
            case "PerformAutoML": {
                return Optional.ofNullable(clazz.cast(this.performAutoML()));
            }
            case "AutoMLOverrideStrategy": {
                return Optional.ofNullable(clazz.cast(this.autoMLOverrideStrategyAsString()));
            }
            case "PerformHPO": {
                return Optional.ofNullable(clazz.cast(this.performHPO()));
            }
            case "TrainingParameters": {
                return Optional.ofNullable(clazz.cast(this.trainingParameters()));
            }
            case "EvaluationParameters": {
                return Optional.ofNullable(clazz.cast(this.evaluationParameters()));
            }
            case "HPOConfig": {
                return Optional.ofNullable(clazz.cast(this.hpoConfig()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "FeaturizationConfig": {
                return Optional.ofNullable(clazz.cast(this.featurizationConfig()));
            }
            case "EncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePredictorRequest, T> g) {
        return obj -> g.apply((CreatePredictorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String predictorName;
        private String algorithmArn;
        private Integer forecastHorizon;
        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean performAutoML;
        private String autoMLOverrideStrategy;
        private Boolean performHPO;
        private Map<String, String> trainingParameters = DefaultSdkAutoConstructMap.getInstance();
        private EvaluationParameters evaluationParameters;
        private HyperParameterTuningJobConfig hpoConfig;
        private InputDataConfig inputDataConfig;
        private FeaturizationConfig featurizationConfig;
        private EncryptionConfig encryptionConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePredictorRequest model) {
            super(model);
            this.predictorName(model.predictorName);
            this.algorithmArn(model.algorithmArn);
            this.forecastHorizon(model.forecastHorizon);
            this.forecastTypes(model.forecastTypes);
            this.performAutoML(model.performAutoML);
            this.autoMLOverrideStrategy(model.autoMLOverrideStrategy);
            this.performHPO(model.performHPO);
            this.trainingParameters(model.trainingParameters);
            this.evaluationParameters(model.evaluationParameters);
            this.hpoConfig(model.hpoConfig);
            this.inputDataConfig(model.inputDataConfig);
            this.featurizationConfig(model.featurizationConfig);
            this.encryptionConfig(model.encryptionConfig);
            this.tags(model.tags);
        }

        public final String getPredictorName() {
            return this.predictorName;
        }

        @Override
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        public final Integer getForecastHorizon() {
            return this.forecastHorizon;
        }

        @Override
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        public final Collection<String> getForecastTypes() {
            if (this.forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastTypes;
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String ... forecastTypes) {
            this.forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        public final Boolean getPerformAutoML() {
            return this.performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        public final String getAutoMLOverrideStrategy() {
            return this.autoMLOverrideStrategy;
        }

        @Override
        public final Builder autoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
            return this;
        }

        @Override
        public final Builder autoMLOverrideStrategy(AutoMLOverrideStrategy autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy(autoMLOverrideStrategy == null ? null : autoMLOverrideStrategy.toString());
            return this;
        }

        public final void setAutoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
        }

        public final Boolean getPerformHPO() {
            return this.performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        public final Map<String, String> getTrainingParameters() {
            if (this.trainingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.trainingParameters;
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        public final EvaluationParameters.Builder getEvaluationParameters() {
            return this.evaluationParameters != null ? this.evaluationParameters.toBuilder() : null;
        }

        @Override
        public final Builder evaluationParameters(EvaluationParameters evaluationParameters) {
            this.evaluationParameters = evaluationParameters;
            return this;
        }

        public final void setEvaluationParameters(EvaluationParameters.BuilderImpl evaluationParameters) {
            this.evaluationParameters = evaluationParameters != null ? evaluationParameters.build() : null;
        }

        public final HyperParameterTuningJobConfig.Builder getHpoConfig() {
            return this.hpoConfig != null ? this.hpoConfig.toBuilder() : null;
        }

        @Override
        public final Builder hpoConfig(HyperParameterTuningJobConfig hpoConfig) {
            this.hpoConfig = hpoConfig;
            return this;
        }

        public final void setHpoConfig(HyperParameterTuningJobConfig.BuilderImpl hpoConfig) {
            this.hpoConfig = hpoConfig != null ? hpoConfig.build() : null;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final FeaturizationConfig.Builder getFeaturizationConfig() {
            return this.featurizationConfig != null ? this.featurizationConfig.toBuilder() : null;
        }

        @Override
        public final Builder featurizationConfig(FeaturizationConfig featurizationConfig) {
            this.featurizationConfig = featurizationConfig;
            return this;
        }

        public final void setFeaturizationConfig(FeaturizationConfig.BuilderImpl featurizationConfig) {
            this.featurizationConfig = featurizationConfig != null ? featurizationConfig.build() : null;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePredictorRequest build() {
            return new CreatePredictorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePredictorRequest> {
        public Builder predictorName(String var1);

        public Builder algorithmArn(String var1);

        public Builder forecastHorizon(Integer var1);

        public Builder forecastTypes(Collection<String> var1);

        public Builder forecastTypes(String ... var1);

        public Builder performAutoML(Boolean var1);

        public Builder autoMLOverrideStrategy(String var1);

        public Builder autoMLOverrideStrategy(AutoMLOverrideStrategy var1);

        public Builder performHPO(Boolean var1);

        public Builder trainingParameters(Map<String, String> var1);

        public Builder evaluationParameters(EvaluationParameters var1);

        default public Builder evaluationParameters(Consumer<EvaluationParameters.Builder> evaluationParameters) {
            return this.evaluationParameters((EvaluationParameters)((EvaluationParameters.Builder)EvaluationParameters.builder().applyMutation(evaluationParameters)).build());
        }

        public Builder hpoConfig(HyperParameterTuningJobConfig var1);

        default public Builder hpoConfig(Consumer<HyperParameterTuningJobConfig.Builder> hpoConfig) {
            return this.hpoConfig((HyperParameterTuningJobConfig)((HyperParameterTuningJobConfig.Builder)HyperParameterTuningJobConfig.builder().applyMutation(hpoConfig)).build());
        }

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder featurizationConfig(FeaturizationConfig var1);

        default public Builder featurizationConfig(Consumer<FeaturizationConfig.Builder> featurizationConfig) {
            return this.featurizationConfig((FeaturizationConfig)((FeaturizationConfig.Builder)FeaturizationConfig.builder().applyMutation(featurizationConfig)).build());
        }

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

