/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.forecast.model.DataSource;
import software.amazon.awssdk.services.forecast.model.FieldStatisticsCopier;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.Statistics;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatasetImportJobResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeDatasetImportJobResponse> {
    private static final SdkField<String> DATASET_IMPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetImportJobName").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::datasetImportJobName)).setter(DescribeDatasetImportJobResponse.setter(Builder::datasetImportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobName").build()}).build();
    private static final SdkField<String> DATASET_IMPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetImportJobArn").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::datasetImportJobArn)).setter(DescribeDatasetImportJobResponse.setter(Builder::datasetImportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArn").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::datasetArn)).setter(DescribeDatasetImportJobResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampFormat").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::timestampFormat)).setter(DescribeDatasetImportJobResponse.setter(Builder::timestampFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZone").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::timeZone)).setter(DescribeDatasetImportJobResponse.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<Boolean> USE_GEOLOCATION_FOR_TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseGeolocationForTimeZone").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::useGeolocationForTimeZone)).setter(DescribeDatasetImportJobResponse.setter(Builder::useGeolocationForTimeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseGeolocationForTimeZone").build()}).build();
    private static final SdkField<String> GEOLOCATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeolocationFormat").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::geolocationFormat)).setter(DescribeDatasetImportJobResponse.setter(Builder::geolocationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeolocationFormat").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::dataSource)).setter(DescribeDatasetImportJobResponse.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<Map<String, Statistics>> FIELD_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FieldStatistics").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::fieldStatistics)).setter(DescribeDatasetImportJobResponse.setter(Builder::fieldStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldStatistics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Statistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Double> DATA_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DataSize").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::dataSize)).setter(DescribeDatasetImportJobResponse.setter(Builder::dataSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSize").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::status)).setter(DescribeDatasetImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::message)).setter(DescribeDatasetImportJobResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::creationTime)).setter(DescribeDatasetImportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeDatasetImportJobResponse.getter(DescribeDatasetImportJobResponse::lastModificationTime)).setter(DescribeDatasetImportJobResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_NAME_FIELD, DATASET_IMPORT_JOB_ARN_FIELD, DATASET_ARN_FIELD, TIMESTAMP_FORMAT_FIELD, TIME_ZONE_FIELD, USE_GEOLOCATION_FOR_TIME_ZONE_FIELD, GEOLOCATION_FORMAT_FIELD, DATA_SOURCE_FIELD, FIELD_STATISTICS_FIELD, DATA_SIZE_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private final String datasetImportJobName;
    private final String datasetImportJobArn;
    private final String datasetArn;
    private final String timestampFormat;
    private final String timeZone;
    private final Boolean useGeolocationForTimeZone;
    private final String geolocationFormat;
    private final DataSource dataSource;
    private final Map<String, Statistics> fieldStatistics;
    private final Double dataSize;
    private final String status;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private DescribeDatasetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobName = builder.datasetImportJobName;
        this.datasetImportJobArn = builder.datasetImportJobArn;
        this.datasetArn = builder.datasetArn;
        this.timestampFormat = builder.timestampFormat;
        this.timeZone = builder.timeZone;
        this.useGeolocationForTimeZone = builder.useGeolocationForTimeZone;
        this.geolocationFormat = builder.geolocationFormat;
        this.dataSource = builder.dataSource;
        this.fieldStatistics = builder.fieldStatistics;
        this.dataSize = builder.dataSize;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public String datasetImportJobName() {
        return this.datasetImportJobName;
    }

    public String datasetImportJobArn() {
        return this.datasetImportJobArn;
    }

    public String datasetArn() {
        return this.datasetArn;
    }

    public String timestampFormat() {
        return this.timestampFormat;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public Boolean useGeolocationForTimeZone() {
        return this.useGeolocationForTimeZone;
    }

    public String geolocationFormat() {
        return this.geolocationFormat;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public boolean hasFieldStatistics() {
        return this.fieldStatistics != null && !(this.fieldStatistics instanceof SdkAutoConstructMap);
    }

    public Map<String, Statistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public Double dataSize() {
        return this.dataSize;
    }

    public String status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetImportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetImportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.useGeolocationForTimeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.geolocationFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldStatistics() ? this.fieldStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetImportJobResponse)) {
            return false;
        }
        DescribeDatasetImportJobResponse other = (DescribeDatasetImportJobResponse)((Object)obj);
        return Objects.equals(this.datasetImportJobName(), other.datasetImportJobName()) && Objects.equals(this.datasetImportJobArn(), other.datasetImportJobArn()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.timestampFormat(), other.timestampFormat()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.useGeolocationForTimeZone(), other.useGeolocationForTimeZone()) && Objects.equals(this.geolocationFormat(), other.geolocationFormat()) && Objects.equals(this.dataSource(), other.dataSource()) && this.hasFieldStatistics() == other.hasFieldStatistics() && Objects.equals(this.fieldStatistics(), other.fieldStatistics()) && Objects.equals(this.dataSize(), other.dataSize()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDatasetImportJobResponse").add("DatasetImportJobName", (Object)this.datasetImportJobName()).add("DatasetImportJobArn", (Object)this.datasetImportJobArn()).add("DatasetArn", (Object)this.datasetArn()).add("TimestampFormat", (Object)this.timestampFormat()).add("TimeZone", (Object)this.timeZone()).add("UseGeolocationForTimeZone", (Object)this.useGeolocationForTimeZone()).add("GeolocationFormat", (Object)this.geolocationFormat()).add("DataSource", (Object)this.dataSource()).add("FieldStatistics", this.hasFieldStatistics() ? this.fieldStatistics() : null).add("DataSize", (Object)this.dataSize()).add("Status", (Object)this.status()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetImportJobName": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobName()));
            }
            case "DatasetImportJobArn": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobArn()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "TimestampFormat": {
                return Optional.ofNullable(clazz.cast(this.timestampFormat()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "UseGeolocationForTimeZone": {
                return Optional.ofNullable(clazz.cast(this.useGeolocationForTimeZone()));
            }
            case "GeolocationFormat": {
                return Optional.ofNullable(clazz.cast(this.geolocationFormat()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "FieldStatistics": {
                return Optional.ofNullable(clazz.cast(this.fieldStatistics()));
            }
            case "DataSize": {
                return Optional.ofNullable(clazz.cast(this.dataSize()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetImportJobResponse, T> g) {
        return obj -> g.apply((DescribeDatasetImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String datasetImportJobName;
        private String datasetImportJobArn;
        private String datasetArn;
        private String timestampFormat;
        private String timeZone;
        private Boolean useGeolocationForTimeZone;
        private String geolocationFormat;
        private DataSource dataSource;
        private Map<String, Statistics> fieldStatistics = DefaultSdkAutoConstructMap.getInstance();
        private Double dataSize;
        private String status;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetImportJobResponse model) {
            super(model);
            this.datasetImportJobName(model.datasetImportJobName);
            this.datasetImportJobArn(model.datasetImportJobArn);
            this.datasetArn(model.datasetArn);
            this.timestampFormat(model.timestampFormat);
            this.timeZone(model.timeZone);
            this.useGeolocationForTimeZone(model.useGeolocationForTimeZone);
            this.geolocationFormat(model.geolocationFormat);
            this.dataSource(model.dataSource);
            this.fieldStatistics(model.fieldStatistics);
            this.dataSize(model.dataSize);
            this.status(model.status);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetImportJobName() {
            return this.datasetImportJobName;
        }

        @Override
        public final Builder datasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
            return this;
        }

        public final void setDatasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
        }

        public final String getDatasetImportJobArn() {
            return this.datasetImportJobArn;
        }

        @Override
        public final Builder datasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
            return this;
        }

        public final void setDatasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final String getTimestampFormat() {
            return this.timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public final Boolean getUseGeolocationForTimeZone() {
            return this.useGeolocationForTimeZone;
        }

        @Override
        public final Builder useGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
            return this;
        }

        public final void setUseGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
        }

        public final String getGeolocationFormat() {
            return this.geolocationFormat;
        }

        @Override
        public final Builder geolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
            return this;
        }

        public final void setGeolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final Map<String, Statistics.Builder> getFieldStatistics() {
            if (this.fieldStatistics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.fieldStatistics != null ? CollectionUtils.mapValues(this.fieldStatistics, Statistics::toBuilder) : null;
        }

        @Override
        public final Builder fieldStatistics(Map<String, Statistics> fieldStatistics) {
            this.fieldStatistics = FieldStatisticsCopier.copy(fieldStatistics);
            return this;
        }

        public final void setFieldStatistics(Map<String, Statistics.BuilderImpl> fieldStatistics) {
            this.fieldStatistics = FieldStatisticsCopier.copyFromBuilder(fieldStatistics);
        }

        public final Double getDataSize() {
            return this.dataSize;
        }

        @Override
        public final Builder dataSize(Double dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public final void setDataSize(Double dataSize) {
            this.dataSize = dataSize;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribeDatasetImportJobResponse build() {
            return new DescribeDatasetImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatasetImportJobResponse> {
        public Builder datasetImportJobName(String var1);

        public Builder datasetImportJobArn(String var1);

        public Builder datasetArn(String var1);

        public Builder timestampFormat(String var1);

        public Builder timeZone(String var1);

        public Builder useGeolocationForTimeZone(Boolean var1);

        public Builder geolocationFormat(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder fieldStatistics(Map<String, Statistics> var1);

        public Builder dataSize(Double var1);

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

