/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.forecast.model.ArnListCopier;
import software.amazon.awssdk.services.forecast.model.EncryptionConfig;
import software.amazon.awssdk.services.forecast.model.EvaluationParameters;
import software.amazon.awssdk.services.forecast.model.FeaturizationConfig;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.HyperParameterTuningJobConfig;
import software.amazon.awssdk.services.forecast.model.InputDataConfig;
import software.amazon.awssdk.services.forecast.model.PredictorExecutionDetails;
import software.amazon.awssdk.services.forecast.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePredictorResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribePredictorResponse> {
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorArn").getter(DescribePredictorResponse.getter(DescribePredictorResponse::predictorArn)).setter(DescribePredictorResponse.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorName").getter(DescribePredictorResponse.getter(DescribePredictorResponse::predictorName)).setter(DescribePredictorResponse.setter(Builder::predictorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()}).build();
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmArn").getter(DescribePredictorResponse.getter(DescribePredictorResponse::algorithmArn)).setter(DescribePredictorResponse.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()}).build();
    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ForecastHorizon").getter(DescribePredictorResponse.getter(DescribePredictorResponse::forecastHorizon)).setter(DescribePredictorResponse.setter(Builder::forecastHorizon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformAutoML").getter(DescribePredictorResponse.getter(DescribePredictorResponse::performAutoML)).setter(DescribePredictorResponse.setter(Builder::performAutoML)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformAutoML").build()}).build();
    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformHPO").getter(DescribePredictorResponse.getter(DescribePredictorResponse::performHPO)).setter(DescribePredictorResponse.setter(Builder::performHPO)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformHPO").build()}).build();
    private static final SdkField<Map<String, String>> TRAINING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TrainingParameters").getter(DescribePredictorResponse.getter(DescribePredictorResponse::trainingParameters)).setter(DescribePredictorResponse.setter(Builder::trainingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EvaluationParameters> EVALUATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationParameters").getter(DescribePredictorResponse.getter(DescribePredictorResponse::evaluationParameters)).setter(DescribePredictorResponse.setter(Builder::evaluationParameters)).constructor(EvaluationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationParameters").build()}).build();
    private static final SdkField<HyperParameterTuningJobConfig> HPO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HPOConfig").getter(DescribePredictorResponse.getter(DescribePredictorResponse::hpoConfig)).setter(DescribePredictorResponse.setter(Builder::hpoConfig)).constructor(HyperParameterTuningJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HPOConfig").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(DescribePredictorResponse.getter(DescribePredictorResponse::inputDataConfig)).setter(DescribePredictorResponse.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<FeaturizationConfig> FEATURIZATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FeaturizationConfig").getter(DescribePredictorResponse.getter(DescribePredictorResponse::featurizationConfig)).setter(DescribePredictorResponse.setter(Builder::featurizationConfig)).constructor(FeaturizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationConfig").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfig").getter(DescribePredictorResponse.getter(DescribePredictorResponse::encryptionConfig)).setter(DescribePredictorResponse.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()}).build();
    private static final SdkField<PredictorExecutionDetails> PREDICTOR_EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictorExecutionDetails").getter(DescribePredictorResponse.getter(DescribePredictorResponse::predictorExecutionDetails)).setter(DescribePredictorResponse.setter(Builder::predictorExecutionDetails)).constructor(PredictorExecutionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorExecutionDetails").build()}).build();
    private static final SdkField<List<String>> DATASET_IMPORT_JOB_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetImportJobArns").getter(DescribePredictorResponse.getter(DescribePredictorResponse::datasetImportJobArns)).setter(DescribePredictorResponse.setter(Builder::datasetImportJobArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTO_ML_ALGORITHM_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoMLAlgorithmArns").getter(DescribePredictorResponse.getter(DescribePredictorResponse::autoMLAlgorithmArns)).setter(DescribePredictorResponse.setter(Builder::autoMLAlgorithmArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLAlgorithmArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribePredictorResponse.getter(DescribePredictorResponse::status)).setter(DescribePredictorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribePredictorResponse.getter(DescribePredictorResponse::message)).setter(DescribePredictorResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribePredictorResponse.getter(DescribePredictorResponse::creationTime)).setter(DescribePredictorResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribePredictorResponse.getter(DescribePredictorResponse::lastModificationTime)).setter(DescribePredictorResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_ARN_FIELD, PREDICTOR_NAME_FIELD, ALGORITHM_ARN_FIELD, FORECAST_HORIZON_FIELD, PERFORM_AUTO_ML_FIELD, PERFORM_HPO_FIELD, TRAINING_PARAMETERS_FIELD, EVALUATION_PARAMETERS_FIELD, HPO_CONFIG_FIELD, INPUT_DATA_CONFIG_FIELD, FEATURIZATION_CONFIG_FIELD, ENCRYPTION_CONFIG_FIELD, PREDICTOR_EXECUTION_DETAILS_FIELD, DATASET_IMPORT_JOB_ARNS_FIELD, AUTO_ML_ALGORITHM_ARNS_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private final String predictorArn;
    private final String predictorName;
    private final String algorithmArn;
    private final Integer forecastHorizon;
    private final Boolean performAutoML;
    private final Boolean performHPO;
    private final Map<String, String> trainingParameters;
    private final EvaluationParameters evaluationParameters;
    private final HyperParameterTuningJobConfig hpoConfig;
    private final InputDataConfig inputDataConfig;
    private final FeaturizationConfig featurizationConfig;
    private final EncryptionConfig encryptionConfig;
    private final PredictorExecutionDetails predictorExecutionDetails;
    private final List<String> datasetImportJobArns;
    private final List<String> autoMLAlgorithmArns;
    private final String status;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private DescribePredictorResponse(BuilderImpl builder) {
        super(builder);
        this.predictorArn = builder.predictorArn;
        this.predictorName = builder.predictorName;
        this.algorithmArn = builder.algorithmArn;
        this.forecastHorizon = builder.forecastHorizon;
        this.performAutoML = builder.performAutoML;
        this.performHPO = builder.performHPO;
        this.trainingParameters = builder.trainingParameters;
        this.evaluationParameters = builder.evaluationParameters;
        this.hpoConfig = builder.hpoConfig;
        this.inputDataConfig = builder.inputDataConfig;
        this.featurizationConfig = builder.featurizationConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.predictorExecutionDetails = builder.predictorExecutionDetails;
        this.datasetImportJobArns = builder.datasetImportJobArns;
        this.autoMLAlgorithmArns = builder.autoMLAlgorithmArns;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public String predictorArn() {
        return this.predictorArn;
    }

    public String predictorName() {
        return this.predictorName;
    }

    public String algorithmArn() {
        return this.algorithmArn;
    }

    public Integer forecastHorizon() {
        return this.forecastHorizon;
    }

    public Boolean performAutoML() {
        return this.performAutoML;
    }

    public Boolean performHPO() {
        return this.performHPO;
    }

    public boolean hasTrainingParameters() {
        return this.trainingParameters != null && !(this.trainingParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> trainingParameters() {
        return this.trainingParameters;
    }

    public EvaluationParameters evaluationParameters() {
        return this.evaluationParameters;
    }

    public HyperParameterTuningJobConfig hpoConfig() {
        return this.hpoConfig;
    }

    public InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public FeaturizationConfig featurizationConfig() {
        return this.featurizationConfig;
    }

    public EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    public PredictorExecutionDetails predictorExecutionDetails() {
        return this.predictorExecutionDetails;
    }

    public boolean hasDatasetImportJobArns() {
        return this.datasetImportJobArns != null && !(this.datasetImportJobArns instanceof SdkAutoConstructList);
    }

    public List<String> datasetImportJobArns() {
        return this.datasetImportJobArns;
    }

    public boolean hasAutoMLAlgorithmArns() {
        return this.autoMLAlgorithmArns != null && !(this.autoMLAlgorithmArns instanceof SdkAutoConstructList);
    }

    public List<String> autoMLAlgorithmArns() {
        return this.autoMLAlgorithmArns;
    }

    public String status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(this.performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingParameters() ? this.trainingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hpoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.featurizationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorExecutionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetImportJobArns() ? this.datasetImportJobArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoMLAlgorithmArns() ? this.autoMLAlgorithmArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePredictorResponse)) {
            return false;
        }
        DescribePredictorResponse other = (DescribePredictorResponse)((Object)obj);
        return Objects.equals(this.predictorArn(), other.predictorArn()) && Objects.equals(this.predictorName(), other.predictorName()) && Objects.equals(this.algorithmArn(), other.algorithmArn()) && Objects.equals(this.forecastHorizon(), other.forecastHorizon()) && Objects.equals(this.performAutoML(), other.performAutoML()) && Objects.equals(this.performHPO(), other.performHPO()) && this.hasTrainingParameters() == other.hasTrainingParameters() && Objects.equals(this.trainingParameters(), other.trainingParameters()) && Objects.equals(this.evaluationParameters(), other.evaluationParameters()) && Objects.equals(this.hpoConfig(), other.hpoConfig()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.featurizationConfig(), other.featurizationConfig()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && Objects.equals(this.predictorExecutionDetails(), other.predictorExecutionDetails()) && this.hasDatasetImportJobArns() == other.hasDatasetImportJobArns() && Objects.equals(this.datasetImportJobArns(), other.datasetImportJobArns()) && this.hasAutoMLAlgorithmArns() == other.hasAutoMLAlgorithmArns() && Objects.equals(this.autoMLAlgorithmArns(), other.autoMLAlgorithmArns()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribePredictorResponse").add("PredictorArn", (Object)this.predictorArn()).add("PredictorName", (Object)this.predictorName()).add("AlgorithmArn", (Object)this.algorithmArn()).add("ForecastHorizon", (Object)this.forecastHorizon()).add("PerformAutoML", (Object)this.performAutoML()).add("PerformHPO", (Object)this.performHPO()).add("TrainingParameters", this.hasTrainingParameters() ? this.trainingParameters() : null).add("EvaluationParameters", (Object)this.evaluationParameters()).add("HPOConfig", (Object)this.hpoConfig()).add("InputDataConfig", (Object)this.inputDataConfig()).add("FeaturizationConfig", (Object)this.featurizationConfig()).add("EncryptionConfig", (Object)this.encryptionConfig()).add("PredictorExecutionDetails", (Object)this.predictorExecutionDetails()).add("DatasetImportJobArns", this.hasDatasetImportJobArns() ? this.datasetImportJobArns() : null).add("AutoMLAlgorithmArns", this.hasAutoMLAlgorithmArns() ? this.autoMLAlgorithmArns() : null).add("Status", (Object)this.status()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
            case "PredictorName": {
                return Optional.ofNullable(clazz.cast(this.predictorName()));
            }
            case "AlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "ForecastHorizon": {
                return Optional.ofNullable(clazz.cast(this.forecastHorizon()));
            }
            case "PerformAutoML": {
                return Optional.ofNullable(clazz.cast(this.performAutoML()));
            }
            case "PerformHPO": {
                return Optional.ofNullable(clazz.cast(this.performHPO()));
            }
            case "TrainingParameters": {
                return Optional.ofNullable(clazz.cast(this.trainingParameters()));
            }
            case "EvaluationParameters": {
                return Optional.ofNullable(clazz.cast(this.evaluationParameters()));
            }
            case "HPOConfig": {
                return Optional.ofNullable(clazz.cast(this.hpoConfig()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "FeaturizationConfig": {
                return Optional.ofNullable(clazz.cast(this.featurizationConfig()));
            }
            case "EncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "PredictorExecutionDetails": {
                return Optional.ofNullable(clazz.cast(this.predictorExecutionDetails()));
            }
            case "DatasetImportJobArns": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobArns()));
            }
            case "AutoMLAlgorithmArns": {
                return Optional.ofNullable(clazz.cast(this.autoMLAlgorithmArns()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePredictorResponse, T> g) {
        return obj -> g.apply((DescribePredictorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String predictorArn;
        private String predictorName;
        private String algorithmArn;
        private Integer forecastHorizon;
        private Boolean performAutoML;
        private Boolean performHPO;
        private Map<String, String> trainingParameters = DefaultSdkAutoConstructMap.getInstance();
        private EvaluationParameters evaluationParameters;
        private HyperParameterTuningJobConfig hpoConfig;
        private InputDataConfig inputDataConfig;
        private FeaturizationConfig featurizationConfig;
        private EncryptionConfig encryptionConfig;
        private PredictorExecutionDetails predictorExecutionDetails;
        private List<String> datasetImportJobArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> autoMLAlgorithmArns = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePredictorResponse model) {
            super(model);
            this.predictorArn(model.predictorArn);
            this.predictorName(model.predictorName);
            this.algorithmArn(model.algorithmArn);
            this.forecastHorizon(model.forecastHorizon);
            this.performAutoML(model.performAutoML);
            this.performHPO(model.performHPO);
            this.trainingParameters(model.trainingParameters);
            this.evaluationParameters(model.evaluationParameters);
            this.hpoConfig(model.hpoConfig);
            this.inputDataConfig(model.inputDataConfig);
            this.featurizationConfig(model.featurizationConfig);
            this.encryptionConfig(model.encryptionConfig);
            this.predictorExecutionDetails(model.predictorExecutionDetails);
            this.datasetImportJobArns(model.datasetImportJobArns);
            this.autoMLAlgorithmArns(model.autoMLAlgorithmArns);
            this.status(model.status);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        public final String getPredictorName() {
            return this.predictorName;
        }

        @Override
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        public final Integer getForecastHorizon() {
            return this.forecastHorizon;
        }

        @Override
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        public final Boolean getPerformAutoML() {
            return this.performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        public final Boolean getPerformHPO() {
            return this.performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        public final Map<String, String> getTrainingParameters() {
            if (this.trainingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.trainingParameters;
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        public final EvaluationParameters.Builder getEvaluationParameters() {
            return this.evaluationParameters != null ? this.evaluationParameters.toBuilder() : null;
        }

        @Override
        public final Builder evaluationParameters(EvaluationParameters evaluationParameters) {
            this.evaluationParameters = evaluationParameters;
            return this;
        }

        public final void setEvaluationParameters(EvaluationParameters.BuilderImpl evaluationParameters) {
            this.evaluationParameters = evaluationParameters != null ? evaluationParameters.build() : null;
        }

        public final HyperParameterTuningJobConfig.Builder getHpoConfig() {
            return this.hpoConfig != null ? this.hpoConfig.toBuilder() : null;
        }

        @Override
        public final Builder hpoConfig(HyperParameterTuningJobConfig hpoConfig) {
            this.hpoConfig = hpoConfig;
            return this;
        }

        public final void setHpoConfig(HyperParameterTuningJobConfig.BuilderImpl hpoConfig) {
            this.hpoConfig = hpoConfig != null ? hpoConfig.build() : null;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final FeaturizationConfig.Builder getFeaturizationConfig() {
            return this.featurizationConfig != null ? this.featurizationConfig.toBuilder() : null;
        }

        @Override
        public final Builder featurizationConfig(FeaturizationConfig featurizationConfig) {
            this.featurizationConfig = featurizationConfig;
            return this;
        }

        public final void setFeaturizationConfig(FeaturizationConfig.BuilderImpl featurizationConfig) {
            this.featurizationConfig = featurizationConfig != null ? featurizationConfig.build() : null;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        public final PredictorExecutionDetails.Builder getPredictorExecutionDetails() {
            return this.predictorExecutionDetails != null ? this.predictorExecutionDetails.toBuilder() : null;
        }

        @Override
        public final Builder predictorExecutionDetails(PredictorExecutionDetails predictorExecutionDetails) {
            this.predictorExecutionDetails = predictorExecutionDetails;
            return this;
        }

        public final void setPredictorExecutionDetails(PredictorExecutionDetails.BuilderImpl predictorExecutionDetails) {
            this.predictorExecutionDetails = predictorExecutionDetails != null ? predictorExecutionDetails.build() : null;
        }

        public final Collection<String> getDatasetImportJobArns() {
            if (this.datasetImportJobArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasetImportJobArns;
        }

        @Override
        public final Builder datasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobArns(String ... datasetImportJobArns) {
            this.datasetImportJobArns(Arrays.asList(datasetImportJobArns));
            return this;
        }

        public final void setDatasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
        }

        public final Collection<String> getAutoMLAlgorithmArns() {
            if (this.autoMLAlgorithmArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoMLAlgorithmArns;
        }

        @Override
        public final Builder autoMLAlgorithmArns(Collection<String> autoMLAlgorithmArns) {
            this.autoMLAlgorithmArns = ArnListCopier.copy(autoMLAlgorithmArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLAlgorithmArns(String ... autoMLAlgorithmArns) {
            this.autoMLAlgorithmArns(Arrays.asList(autoMLAlgorithmArns));
            return this;
        }

        public final void setAutoMLAlgorithmArns(Collection<String> autoMLAlgorithmArns) {
            this.autoMLAlgorithmArns = ArnListCopier.copy(autoMLAlgorithmArns);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribePredictorResponse build() {
            return new DescribePredictorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePredictorResponse> {
        public Builder predictorArn(String var1);

        public Builder predictorName(String var1);

        public Builder algorithmArn(String var1);

        public Builder forecastHorizon(Integer var1);

        public Builder performAutoML(Boolean var1);

        public Builder performHPO(Boolean var1);

        public Builder trainingParameters(Map<String, String> var1);

        public Builder evaluationParameters(EvaluationParameters var1);

        default public Builder evaluationParameters(Consumer<EvaluationParameters.Builder> evaluationParameters) {
            return this.evaluationParameters((EvaluationParameters)((EvaluationParameters.Builder)EvaluationParameters.builder().applyMutation(evaluationParameters)).build());
        }

        public Builder hpoConfig(HyperParameterTuningJobConfig var1);

        default public Builder hpoConfig(Consumer<HyperParameterTuningJobConfig.Builder> hpoConfig) {
            return this.hpoConfig((HyperParameterTuningJobConfig)((HyperParameterTuningJobConfig.Builder)HyperParameterTuningJobConfig.builder().applyMutation(hpoConfig)).build());
        }

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder featurizationConfig(FeaturizationConfig var1);

        default public Builder featurizationConfig(Consumer<FeaturizationConfig.Builder> featurizationConfig) {
            return this.featurizationConfig((FeaturizationConfig)((FeaturizationConfig.Builder)FeaturizationConfig.builder().applyMutation(featurizationConfig)).build());
        }

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }

        public Builder predictorExecutionDetails(PredictorExecutionDetails var1);

        default public Builder predictorExecutionDetails(Consumer<PredictorExecutionDetails.Builder> predictorExecutionDetails) {
            return this.predictorExecutionDetails((PredictorExecutionDetails)((PredictorExecutionDetails.Builder)PredictorExecutionDetails.builder().applyMutation(predictorExecutionDetails)).build());
        }

        public Builder datasetImportJobArns(Collection<String> var1);

        public Builder datasetImportJobArns(String ... var1);

        public Builder autoMLAlgorithmArns(Collection<String> var1);

        public Builder autoMLAlgorithmArns(String ... var1);

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

