/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.ForecastTypesCopier;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateForecastRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateForecastRequest> {
    private static final SdkField<String> FORECAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastName").getter(CreateForecastRequest.getter(CreateForecastRequest::forecastName)).setter(CreateForecastRequest.setter(Builder::forecastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastName").build()}).build();
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorArn").getter(CreateForecastRequest.getter(CreateForecastRequest::predictorArn)).setter(CreateForecastRequest.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastTypes").getter(CreateForecastRequest.getter(CreateForecastRequest::forecastTypes)).setter(CreateForecastRequest.setter(Builder::forecastTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateForecastRequest.getter(CreateForecastRequest::tags)).setter(CreateForecastRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_NAME_FIELD, PREDICTOR_ARN_FIELD, FORECAST_TYPES_FIELD, TAGS_FIELD));
    private final String forecastName;
    private final String predictorArn;
    private final List<String> forecastTypes;
    private final List<Tag> tags;

    private CreateForecastRequest(BuilderImpl builder) {
        super(builder);
        this.forecastName = builder.forecastName;
        this.predictorArn = builder.predictorArn;
        this.forecastTypes = builder.forecastTypes;
        this.tags = builder.tags;
    }

    public String forecastName() {
        return this.forecastName;
    }

    public String predictorArn() {
        return this.predictorArn;
    }

    public boolean hasForecastTypes() {
        return this.forecastTypes != null && !(this.forecastTypes instanceof SdkAutoConstructList);
    }

    public List<String> forecastTypes() {
        return this.forecastTypes;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastTypes() ? this.forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateForecastRequest)) {
            return false;
        }
        CreateForecastRequest other = (CreateForecastRequest)((Object)obj);
        return Objects.equals(this.forecastName(), other.forecastName()) && Objects.equals(this.predictorArn(), other.predictorArn()) && this.hasForecastTypes() == other.hasForecastTypes() && Objects.equals(this.forecastTypes(), other.forecastTypes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateForecastRequest").add("ForecastName", (Object)this.forecastName()).add("PredictorArn", (Object)this.predictorArn()).add("ForecastTypes", this.hasForecastTypes() ? this.forecastTypes() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastName": {
                return Optional.ofNullable(clazz.cast(this.forecastName()));
            }
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
            case "ForecastTypes": {
                return Optional.ofNullable(clazz.cast(this.forecastTypes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateForecastRequest, T> g) {
        return obj -> g.apply((CreateForecastRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String forecastName;
        private String predictorArn;
        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateForecastRequest model) {
            super(model);
            this.forecastName(model.forecastName);
            this.predictorArn(model.predictorArn);
            this.forecastTypes(model.forecastTypes);
            this.tags(model.tags);
        }

        public final String getForecastName() {
            return this.forecastName;
        }

        @Override
        public final Builder forecastName(String forecastName) {
            this.forecastName = forecastName;
            return this;
        }

        public final void setForecastName(String forecastName) {
            this.forecastName = forecastName;
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        public final Collection<String> getForecastTypes() {
            if (this.forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastTypes;
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String ... forecastTypes) {
            this.forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateForecastRequest build() {
            return new CreateForecastRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateForecastRequest> {
        public Builder forecastName(String var1);

        public Builder predictorArn(String var1);

        public Builder forecastTypes(Collection<String> var1);

        public Builder forecastTypes(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

