/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.forecast.model.FeaturizationMethodName;
import software.amazon.awssdk.services.forecast.model.FeaturizationMethodParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeaturizationMethod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeaturizationMethod> {
    private static final SdkField<String> FEATURIZATION_METHOD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FeaturizationMethod.getter(FeaturizationMethod::featurizationMethodNameAsString)).setter(FeaturizationMethod.setter(Builder::featurizationMethodName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationMethodName").build()}).build();
    private static final SdkField<Map<String, String>> FEATURIZATION_METHOD_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(FeaturizationMethod.getter(FeaturizationMethod::featurizationMethodParameters)).setter(FeaturizationMethod.setter(Builder::featurizationMethodParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationMethodParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURIZATION_METHOD_NAME_FIELD, FEATURIZATION_METHOD_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String featurizationMethodName;
    private final Map<String, String> featurizationMethodParameters;

    private FeaturizationMethod(BuilderImpl builder) {
        this.featurizationMethodName = builder.featurizationMethodName;
        this.featurizationMethodParameters = builder.featurizationMethodParameters;
    }

    public FeaturizationMethodName featurizationMethodName() {
        return FeaturizationMethodName.fromValue(this.featurizationMethodName);
    }

    public String featurizationMethodNameAsString() {
        return this.featurizationMethodName;
    }

    public Map<String, String> featurizationMethodParameters() {
        return this.featurizationMethodParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featurizationMethodNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.featurizationMethodParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturizationMethod)) {
            return false;
        }
        FeaturizationMethod other = (FeaturizationMethod)obj;
        return Objects.equals(this.featurizationMethodNameAsString(), other.featurizationMethodNameAsString()) && Objects.equals(this.featurizationMethodParameters(), other.featurizationMethodParameters());
    }

    public String toString() {
        return ToString.builder((String)"FeaturizationMethod").add("FeaturizationMethodName", (Object)this.featurizationMethodNameAsString()).add("FeaturizationMethodParameters", this.featurizationMethodParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeaturizationMethodName": {
                return Optional.ofNullable(clazz.cast(this.featurizationMethodNameAsString()));
            }
            case "FeaturizationMethodParameters": {
                return Optional.ofNullable(clazz.cast(this.featurizationMethodParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeaturizationMethod, T> g) {
        return obj -> g.apply((FeaturizationMethod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featurizationMethodName;
        private Map<String, String> featurizationMethodParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturizationMethod model) {
            this.featurizationMethodName(model.featurizationMethodName);
            this.featurizationMethodParameters(model.featurizationMethodParameters);
        }

        public final String getFeaturizationMethodNameAsString() {
            return this.featurizationMethodName;
        }

        @Override
        public final Builder featurizationMethodName(String featurizationMethodName) {
            this.featurizationMethodName = featurizationMethodName;
            return this;
        }

        @Override
        public final Builder featurizationMethodName(FeaturizationMethodName featurizationMethodName) {
            this.featurizationMethodName(featurizationMethodName == null ? null : featurizationMethodName.toString());
            return this;
        }

        public final void setFeaturizationMethodName(String featurizationMethodName) {
            this.featurizationMethodName = featurizationMethodName;
        }

        public final Map<String, String> getFeaturizationMethodParameters() {
            return this.featurizationMethodParameters;
        }

        @Override
        public final Builder featurizationMethodParameters(Map<String, String> featurizationMethodParameters) {
            this.featurizationMethodParameters = FeaturizationMethodParametersCopier.copy(featurizationMethodParameters);
            return this;
        }

        public final void setFeaturizationMethodParameters(Map<String, String> featurizationMethodParameters) {
            this.featurizationMethodParameters = FeaturizationMethodParametersCopier.copy(featurizationMethodParameters);
        }

        public FeaturizationMethod build() {
            return new FeaturizationMethod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeaturizationMethod> {
        public Builder featurizationMethodName(String var1);

        public Builder featurizationMethodName(FeaturizationMethodName var1);

        public Builder featurizationMethodParameters(Map<String, String> var1);
    }
}

