/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutNotificationChannelRequest extends FmsRequest implements
        ToCopyableBuilder<PutNotificationChannelRequest.Builder, PutNotificationChannelRequest> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(PutNotificationChannelRequest::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SNS_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsRoleName").getter(getter(PutNotificationChannelRequest::snsRoleName))
            .setter(setter(Builder::snsRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsRoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD,
            SNS_ROLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snsTopicArn;

    private final String snsRoleName;

    private PutNotificationChannelRequest(BuilderImpl builder) {
        super(builder);
        this.snsTopicArn = builder.snsTopicArn;
        this.snsRoleName = builder.snsRoleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager activity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager
     *         activity.
     */
    public final String snsRoleName() {
        return snsRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsRoleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationChannelRequest)) {
            return false;
        }
        PutNotificationChannelRequest other = (PutNotificationChannelRequest) obj;
        return Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(snsRoleName(), other.snsRoleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutNotificationChannelRequest").add("SnsTopicArn", snsTopicArn())
                .add("SnsRoleName", snsRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SnsRoleName":
            return Optional.ofNullable(clazz.cast(snsRoleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("SnsRoleName", SNS_ROLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutNotificationChannelRequest, T> g) {
        return obj -> g.apply((PutNotificationChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutNotificationChannelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager activity.
         * </p>
         * 
         * @param snsRoleName
         *        The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager
         *        activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsRoleName(String snsRoleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String snsTopicArn;

        private String snsRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationChannelRequest model) {
            super(model);
            snsTopicArn(model.snsTopicArn);
            snsRoleName(model.snsRoleName);
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsRoleName() {
            return snsRoleName;
        }

        public final void setSnsRoleName(String snsRoleName) {
            this.snsRoleName = snsRoleName;
        }

        @Override
        public final Builder snsRoleName(String snsRoleName) {
            this.snsRoleName = snsRoleName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutNotificationChannelRequest build() {
            return new PutNotificationChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
