/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference rule that partially matches the <code>ViolationTarget</code> rule and violation reason.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartialMatch implements SdkPojo, Serializable, ToCopyableBuilder<PartialMatch.Builder, PartialMatch> {
    private static final SdkField<String> REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Reference").getter(getter(PartialMatch::reference)).setter(setter(Builder::reference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reference").build()).build();

    private static final SdkField<List<String>> TARGET_VIOLATION_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetViolationReasons")
            .getter(getter(PartialMatch::targetViolationReasons))
            .setter(setter(Builder::targetViolationReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetViolationReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_FIELD,
            TARGET_VIOLATION_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reference;

    private final List<String> targetViolationReasons;

    private PartialMatch(BuilderImpl builder) {
        this.reference = builder.reference;
        this.targetViolationReasons = builder.targetViolationReasons;
    }

    /**
     * <p>
     * The reference rule from the primary security group of the Firewall Manager policy.
     * </p>
     * 
     * @return The reference rule from the primary security group of the Firewall Manager policy.
     */
    public final String reference() {
        return reference;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetViolationReasons property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetViolationReasons() {
        return targetViolationReasons != null && !(targetViolationReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The violation reason.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetViolationReasons} method.
     * </p>
     * 
     * @return The violation reason.
     */
    public final List<String> targetViolationReasons() {
        return targetViolationReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetViolationReasons() ? targetViolationReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartialMatch)) {
            return false;
        }
        PartialMatch other = (PartialMatch) obj;
        return Objects.equals(reference(), other.reference()) && hasTargetViolationReasons() == other.hasTargetViolationReasons()
                && Objects.equals(targetViolationReasons(), other.targetViolationReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartialMatch").add("Reference", reference())
                .add("TargetViolationReasons", hasTargetViolationReasons() ? targetViolationReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reference":
            return Optional.ofNullable(clazz.cast(reference()));
        case "TargetViolationReasons":
            return Optional.ofNullable(clazz.cast(targetViolationReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Reference", REFERENCE_FIELD);
        map.put("TargetViolationReasons", TARGET_VIOLATION_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartialMatch, T> g) {
        return obj -> g.apply((PartialMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartialMatch> {
        /**
         * <p>
         * The reference rule from the primary security group of the Firewall Manager policy.
         * </p>
         * 
         * @param reference
         *        The reference rule from the primary security group of the Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(String reference);

        /**
         * <p>
         * The violation reason.
         * </p>
         * 
         * @param targetViolationReasons
         *        The violation reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetViolationReasons(Collection<String> targetViolationReasons);

        /**
         * <p>
         * The violation reason.
         * </p>
         * 
         * @param targetViolationReasons
         *        The violation reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetViolationReasons(String... targetViolationReasons);
    }

    static final class BuilderImpl implements Builder {
        private String reference;

        private List<String> targetViolationReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartialMatch model) {
            reference(model.reference);
            targetViolationReasons(model.targetViolationReasons);
        }

        public final String getReference() {
            return reference;
        }

        public final void setReference(String reference) {
            this.reference = reference;
        }

        @Override
        public final Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public final Collection<String> getTargetViolationReasons() {
            if (targetViolationReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return targetViolationReasons;
        }

        public final void setTargetViolationReasons(Collection<String> targetViolationReasons) {
            this.targetViolationReasons = TargetViolationReasonsCopier.copy(targetViolationReasons);
        }

        @Override
        public final Builder targetViolationReasons(Collection<String> targetViolationReasons) {
            this.targetViolationReasons = TargetViolationReasonsCopier.copy(targetViolationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetViolationReasons(String... targetViolationReasons) {
            targetViolationReasons(Arrays.asList(targetViolationReasons));
            return this;
        }

        @Override
        public PartialMatch build() {
            return new PartialMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
