/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAdminAccountResponse extends FmsResponse implements
        ToCopyableBuilder<GetAdminAccountResponse.Builder, GetAdminAccountResponse> {
    private static final SdkField<String> ADMIN_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminAccount").getter(getter(GetAdminAccountResponse::adminAccount))
            .setter(setter(Builder::adminAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccount").build()).build();

    private static final SdkField<String> ROLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleStatus").getter(getter(GetAdminAccountResponse::roleStatusAsString))
            .setter(setter(Builder::roleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_FIELD,
            ROLE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String adminAccount;

    private final String roleStatus;

    private GetAdminAccountResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccount = builder.adminAccount;
        this.roleStatus = builder.roleStatus;
    }

    /**
     * <p>
     * The account that is set as the Firewall Manager default administrator.
     * </p>
     * 
     * @return The account that is set as the Firewall Manager default administrator.
     */
    public final String adminAccount() {
        return adminAccount;
    }

    /**
     * <p>
     * The status of the account that you set as the Firewall Manager default administrator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleStatus} will
     * return {@link AccountRoleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleStatusAsString}.
     * </p>
     * 
     * @return The status of the account that you set as the Firewall Manager default administrator.
     * @see AccountRoleStatus
     */
    public final AccountRoleStatus roleStatus() {
        return AccountRoleStatus.fromValue(roleStatus);
    }

    /**
     * <p>
     * The status of the account that you set as the Firewall Manager default administrator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleStatus} will
     * return {@link AccountRoleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleStatusAsString}.
     * </p>
     * 
     * @return The status of the account that you set as the Firewall Manager default administrator.
     * @see AccountRoleStatus
     */
    public final String roleStatusAsString() {
        return roleStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminAccount());
        hashCode = 31 * hashCode + Objects.hashCode(roleStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdminAccountResponse)) {
            return false;
        }
        GetAdminAccountResponse other = (GetAdminAccountResponse) obj;
        return Objects.equals(adminAccount(), other.adminAccount())
                && Objects.equals(roleStatusAsString(), other.roleStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAdminAccountResponse").add("AdminAccount", adminAccount())
                .add("RoleStatus", roleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminAccount":
            return Optional.ofNullable(clazz.cast(adminAccount()));
        case "RoleStatus":
            return Optional.ofNullable(clazz.cast(roleStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdminAccount", ADMIN_ACCOUNT_FIELD);
        map.put("RoleStatus", ROLE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAdminAccountResponse, T> g) {
        return obj -> g.apply((GetAdminAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAdminAccountResponse> {
        /**
         * <p>
         * The account that is set as the Firewall Manager default administrator.
         * </p>
         * 
         * @param adminAccount
         *        The account that is set as the Firewall Manager default administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccount(String adminAccount);

        /**
         * <p>
         * The status of the account that you set as the Firewall Manager default administrator.
         * </p>
         * 
         * @param roleStatus
         *        The status of the account that you set as the Firewall Manager default administrator.
         * @see AccountRoleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountRoleStatus
         */
        Builder roleStatus(String roleStatus);

        /**
         * <p>
         * The status of the account that you set as the Firewall Manager default administrator.
         * </p>
         * 
         * @param roleStatus
         *        The status of the account that you set as the Firewall Manager default administrator.
         * @see AccountRoleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountRoleStatus
         */
        Builder roleStatus(AccountRoleStatus roleStatus);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private String adminAccount;

        private String roleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdminAccountResponse model) {
            super(model);
            adminAccount(model.adminAccount);
            roleStatus(model.roleStatus);
        }

        public final String getAdminAccount() {
            return adminAccount;
        }

        public final void setAdminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
        }

        @Override
        public final Builder adminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
            return this;
        }

        public final String getRoleStatus() {
            return roleStatus;
        }

        public final void setRoleStatus(String roleStatus) {
            this.roleStatus = roleStatus;
        }

        @Override
        public final Builder roleStatus(String roleStatus) {
            this.roleStatus = roleStatus;
            return this;
        }

        @Override
        public final Builder roleStatus(AccountRoleStatus roleStatus) {
            this.roleStatus(roleStatus == null ? null : roleStatus.toString());
            return this;
        }

        @Override
        public GetAdminAccountResponse build() {
            return new GetAdminAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
