/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateThirdPartyFirewallResponse extends FmsResponse implements
        ToCopyableBuilder<DisassociateThirdPartyFirewallResponse.Builder, DisassociateThirdPartyFirewallResponse> {
    private static final SdkField<String> THIRD_PARTY_FIREWALL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThirdPartyFirewallStatus")
            .getter(getter(DisassociateThirdPartyFirewallResponse::thirdPartyFirewallStatusAsString))
            .setter(setter(Builder::thirdPartyFirewallStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(THIRD_PARTY_FIREWALL_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thirdPartyFirewallStatus;

    private DisassociateThirdPartyFirewallResponse(BuilderImpl builder) {
        super(builder);
        this.thirdPartyFirewallStatus = builder.thirdPartyFirewallStatus;
    }

    /**
     * <p>
     * The current status for the disassociation of a Firewall Manager administrators account with a third-party
     * firewall.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thirdPartyFirewallStatus} will return {@link ThirdPartyFirewallAssociationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thirdPartyFirewallStatusAsString}.
     * </p>
     * 
     * @return The current status for the disassociation of a Firewall Manager administrators account with a third-party
     *         firewall.
     * @see ThirdPartyFirewallAssociationStatus
     */
    public final ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus() {
        return ThirdPartyFirewallAssociationStatus.fromValue(thirdPartyFirewallStatus);
    }

    /**
     * <p>
     * The current status for the disassociation of a Firewall Manager administrators account with a third-party
     * firewall.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thirdPartyFirewallStatus} will return {@link ThirdPartyFirewallAssociationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thirdPartyFirewallStatusAsString}.
     * </p>
     * 
     * @return The current status for the disassociation of a Firewall Manager administrators account with a third-party
     *         firewall.
     * @see ThirdPartyFirewallAssociationStatus
     */
    public final String thirdPartyFirewallStatusAsString() {
        return thirdPartyFirewallStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thirdPartyFirewallStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateThirdPartyFirewallResponse)) {
            return false;
        }
        DisassociateThirdPartyFirewallResponse other = (DisassociateThirdPartyFirewallResponse) obj;
        return Objects.equals(thirdPartyFirewallStatusAsString(), other.thirdPartyFirewallStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateThirdPartyFirewallResponse")
                .add("ThirdPartyFirewallStatus", thirdPartyFirewallStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThirdPartyFirewallStatus":
            return Optional.ofNullable(clazz.cast(thirdPartyFirewallStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ThirdPartyFirewallStatus", THIRD_PARTY_FIREWALL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateThirdPartyFirewallResponse, T> g) {
        return obj -> g.apply((DisassociateThirdPartyFirewallResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FmsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateThirdPartyFirewallResponse> {
        /**
         * <p>
         * The current status for the disassociation of a Firewall Manager administrators account with a third-party
         * firewall.
         * </p>
         * 
         * @param thirdPartyFirewallStatus
         *        The current status for the disassociation of a Firewall Manager administrators account with a
         *        third-party firewall.
         * @see ThirdPartyFirewallAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyFirewallAssociationStatus
         */
        Builder thirdPartyFirewallStatus(String thirdPartyFirewallStatus);

        /**
         * <p>
         * The current status for the disassociation of a Firewall Manager administrators account with a third-party
         * firewall.
         * </p>
         * 
         * @param thirdPartyFirewallStatus
         *        The current status for the disassociation of a Firewall Manager administrators account with a
         *        third-party firewall.
         * @see ThirdPartyFirewallAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyFirewallAssociationStatus
         */
        Builder thirdPartyFirewallStatus(ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private String thirdPartyFirewallStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateThirdPartyFirewallResponse model) {
            super(model);
            thirdPartyFirewallStatus(model.thirdPartyFirewallStatus);
        }

        public final String getThirdPartyFirewallStatus() {
            return thirdPartyFirewallStatus;
        }

        public final void setThirdPartyFirewallStatus(String thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus = thirdPartyFirewallStatus;
        }

        @Override
        public final Builder thirdPartyFirewallStatus(String thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus = thirdPartyFirewallStatus;
            return this;
        }

        @Override
        public final Builder thirdPartyFirewallStatus(ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus(thirdPartyFirewallStatus == null ? null : thirdPartyFirewallStatus.toString());
            return this;
        }

        @Override
        public DisassociateThirdPartyFirewallResponse build() {
            return new DisassociateThirdPartyFirewallResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
