/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNotificationChannelResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, GetNotificationChannelResponse> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetNotificationChannelResponse.getter(GetNotificationChannelResponse::snsTopicArn)).setter(GetNotificationChannelResponse.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SNS_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetNotificationChannelResponse.getter(GetNotificationChannelResponse::snsRoleName)).setter(GetNotificationChannelResponse.setter(Builder::snsRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsRoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD, SNS_ROLE_NAME_FIELD));
    private final String snsTopicArn;
    private final String snsRoleName;

    private GetNotificationChannelResponse(BuilderImpl builder) {
        super(builder);
        this.snsTopicArn = builder.snsTopicArn;
        this.snsRoleName = builder.snsRoleName;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public String snsRoleName() {
        return this.snsRoleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsRoleName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotificationChannelResponse)) {
            return false;
        }
        GetNotificationChannelResponse other = (GetNotificationChannelResponse)((Object)obj);
        return Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.snsRoleName(), other.snsRoleName());
    }

    public String toString() {
        return ToString.builder((String)"GetNotificationChannelResponse").add("SnsTopicArn", (Object)this.snsTopicArn()).add("SnsRoleName", (Object)this.snsRoleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SnsRoleName": {
                return Optional.ofNullable(clazz.cast(this.snsRoleName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNotificationChannelResponse, T> g) {
        return obj -> g.apply((GetNotificationChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private String snsTopicArn;
        private String snsRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotificationChannelResponse model) {
            super(model);
            this.snsTopicArn(model.snsTopicArn);
            this.snsRoleName(model.snsRoleName);
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSnsRoleName() {
            return this.snsRoleName;
        }

        @Override
        public final Builder snsRoleName(String snsRoleName) {
            this.snsRoleName = snsRoleName;
            return this;
        }

        public final void setSnsRoleName(String snsRoleName) {
            this.snsRoleName = snsRoleName;
        }

        @Override
        public GetNotificationChannelResponse build() {
            return new GetNotificationChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNotificationChannelResponse> {
        public Builder snsTopicArn(String var1);

        public Builder snsRoleName(String var1);
    }
}

