/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.NetworkFirewallOverrideAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallStatefulRuleGroupOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallStatefulRuleGroupOverride> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(NetworkFirewallStatefulRuleGroupOverride.getter(NetworkFirewallStatefulRuleGroupOverride::actionAsString)).setter(NetworkFirewallStatefulRuleGroupOverride.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkFirewallStatefulRuleGroupOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;

    private NetworkFirewallStatefulRuleGroupOverride(BuilderImpl builder) {
        this.action = builder.action;
    }

    public final NetworkFirewallOverrideAction action() {
        return NetworkFirewallOverrideAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallStatefulRuleGroupOverride)) {
            return false;
        }
        NetworkFirewallStatefulRuleGroupOverride other = (NetworkFirewallStatefulRuleGroupOverride)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallStatefulRuleGroupOverride").add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallStatefulRuleGroupOverride, T> g) {
        return obj -> g.apply((NetworkFirewallStatefulRuleGroupOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallStatefulRuleGroupOverride model) {
            this.action(model.action);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(NetworkFirewallOverrideAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public NetworkFirewallStatefulRuleGroupOverride build() {
            return new NetworkFirewallStatefulRuleGroupOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallStatefulRuleGroupOverride> {
        public Builder action(String var1);

        public Builder action(NetworkFirewallOverrideAction var1);
    }
}

