/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.NetworkAclCommonPolicy;
import software.amazon.awssdk.services.fms.model.NetworkFirewallPolicy;
import software.amazon.awssdk.services.fms.model.ThirdPartyFirewallPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyOption> {
    private static final SdkField<NetworkFirewallPolicy> NETWORK_FIREWALL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallPolicy").getter(PolicyOption.getter(PolicyOption::networkFirewallPolicy)).setter(PolicyOption.setter(Builder::networkFirewallPolicy)).constructor(NetworkFirewallPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallPolicy").build()}).build();
    private static final SdkField<ThirdPartyFirewallPolicy> THIRD_PARTY_FIREWALL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThirdPartyFirewallPolicy").getter(PolicyOption.getter(PolicyOption::thirdPartyFirewallPolicy)).setter(PolicyOption.setter(Builder::thirdPartyFirewallPolicy)).constructor(ThirdPartyFirewallPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallPolicy").build()}).build();
    private static final SdkField<NetworkAclCommonPolicy> NETWORK_ACL_COMMON_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkAclCommonPolicy").getter(PolicyOption.getter(PolicyOption::networkAclCommonPolicy)).setter(PolicyOption.setter(Builder::networkAclCommonPolicy)).constructor(NetworkAclCommonPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclCommonPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIREWALL_POLICY_FIELD, THIRD_PARTY_FIREWALL_POLICY_FIELD, NETWORK_ACL_COMMON_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NetworkFirewallPolicy networkFirewallPolicy;
    private final ThirdPartyFirewallPolicy thirdPartyFirewallPolicy;
    private final NetworkAclCommonPolicy networkAclCommonPolicy;

    private PolicyOption(BuilderImpl builder) {
        this.networkFirewallPolicy = builder.networkFirewallPolicy;
        this.thirdPartyFirewallPolicy = builder.thirdPartyFirewallPolicy;
        this.networkAclCommonPolicy = builder.networkAclCommonPolicy;
    }

    public final NetworkFirewallPolicy networkFirewallPolicy() {
        return this.networkFirewallPolicy;
    }

    public final ThirdPartyFirewallPolicy thirdPartyFirewallPolicy() {
        return this.thirdPartyFirewallPolicy;
    }

    public final NetworkAclCommonPolicy networkAclCommonPolicy() {
        return this.networkAclCommonPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.thirdPartyFirewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclCommonPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyOption)) {
            return false;
        }
        PolicyOption other = (PolicyOption)obj;
        return Objects.equals(this.networkFirewallPolicy(), other.networkFirewallPolicy()) && Objects.equals(this.thirdPartyFirewallPolicy(), other.thirdPartyFirewallPolicy()) && Objects.equals(this.networkAclCommonPolicy(), other.networkAclCommonPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyOption").add("NetworkFirewallPolicy", (Object)this.networkFirewallPolicy()).add("ThirdPartyFirewallPolicy", (Object)this.thirdPartyFirewallPolicy()).add("NetworkAclCommonPolicy", (Object)this.networkAclCommonPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkFirewallPolicy": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallPolicy()));
            }
            case "ThirdPartyFirewallPolicy": {
                return Optional.ofNullable(clazz.cast(this.thirdPartyFirewallPolicy()));
            }
            case "NetworkAclCommonPolicy": {
                return Optional.ofNullable(clazz.cast(this.networkAclCommonPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkFirewallPolicy", NETWORK_FIREWALL_POLICY_FIELD);
        map.put("ThirdPartyFirewallPolicy", THIRD_PARTY_FIREWALL_POLICY_FIELD);
        map.put("NetworkAclCommonPolicy", NETWORK_ACL_COMMON_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyOption, T> g) {
        return obj -> g.apply((PolicyOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkFirewallPolicy networkFirewallPolicy;
        private ThirdPartyFirewallPolicy thirdPartyFirewallPolicy;
        private NetworkAclCommonPolicy networkAclCommonPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyOption model) {
            this.networkFirewallPolicy(model.networkFirewallPolicy);
            this.thirdPartyFirewallPolicy(model.thirdPartyFirewallPolicy);
            this.networkAclCommonPolicy(model.networkAclCommonPolicy);
        }

        public final NetworkFirewallPolicy.Builder getNetworkFirewallPolicy() {
            return this.networkFirewallPolicy != null ? this.networkFirewallPolicy.toBuilder() : null;
        }

        public final void setNetworkFirewallPolicy(NetworkFirewallPolicy.BuilderImpl networkFirewallPolicy) {
            this.networkFirewallPolicy = networkFirewallPolicy != null ? networkFirewallPolicy.build() : null;
        }

        @Override
        public final Builder networkFirewallPolicy(NetworkFirewallPolicy networkFirewallPolicy) {
            this.networkFirewallPolicy = networkFirewallPolicy;
            return this;
        }

        public final ThirdPartyFirewallPolicy.Builder getThirdPartyFirewallPolicy() {
            return this.thirdPartyFirewallPolicy != null ? this.thirdPartyFirewallPolicy.toBuilder() : null;
        }

        public final void setThirdPartyFirewallPolicy(ThirdPartyFirewallPolicy.BuilderImpl thirdPartyFirewallPolicy) {
            this.thirdPartyFirewallPolicy = thirdPartyFirewallPolicy != null ? thirdPartyFirewallPolicy.build() : null;
        }

        @Override
        public final Builder thirdPartyFirewallPolicy(ThirdPartyFirewallPolicy thirdPartyFirewallPolicy) {
            this.thirdPartyFirewallPolicy = thirdPartyFirewallPolicy;
            return this;
        }

        public final NetworkAclCommonPolicy.Builder getNetworkAclCommonPolicy() {
            return this.networkAclCommonPolicy != null ? this.networkAclCommonPolicy.toBuilder() : null;
        }

        public final void setNetworkAclCommonPolicy(NetworkAclCommonPolicy.BuilderImpl networkAclCommonPolicy) {
            this.networkAclCommonPolicy = networkAclCommonPolicy != null ? networkAclCommonPolicy.build() : null;
        }

        @Override
        public final Builder networkAclCommonPolicy(NetworkAclCommonPolicy networkAclCommonPolicy) {
            this.networkAclCommonPolicy = networkAclCommonPolicy;
            return this;
        }

        public PolicyOption build() {
            return new PolicyOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyOption> {
        public Builder networkFirewallPolicy(NetworkFirewallPolicy var1);

        default public Builder networkFirewallPolicy(Consumer<NetworkFirewallPolicy.Builder> networkFirewallPolicy) {
            return this.networkFirewallPolicy((NetworkFirewallPolicy)((NetworkFirewallPolicy.Builder)NetworkFirewallPolicy.builder().applyMutation(networkFirewallPolicy)).build());
        }

        public Builder thirdPartyFirewallPolicy(ThirdPartyFirewallPolicy var1);

        default public Builder thirdPartyFirewallPolicy(Consumer<ThirdPartyFirewallPolicy.Builder> thirdPartyFirewallPolicy) {
            return this.thirdPartyFirewallPolicy((ThirdPartyFirewallPolicy)((ThirdPartyFirewallPolicy.Builder)ThirdPartyFirewallPolicy.builder().applyMutation(thirdPartyFirewallPolicy)).build());
        }

        public Builder networkAclCommonPolicy(NetworkAclCommonPolicy var1);

        default public Builder networkAclCommonPolicy(Consumer<NetworkAclCommonPolicy.Builder> networkAclCommonPolicy) {
            return this.networkAclCommonPolicy((NetworkAclCommonPolicy)((NetworkAclCommonPolicy.Builder)NetworkAclCommonPolicy.builder().applyMutation(networkAclCommonPolicy)).build());
        }
    }
}

