/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ResourceViolation;
import software.amazon.awssdk.services.fms.model.ResourceViolationsCopier;
import software.amazon.awssdk.services.fms.model.Tag;
import software.amazon.awssdk.services.fms.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViolationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViolationDetail> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(ViolationDetail.getter(ViolationDetail::policyId)).setter(ViolationDetail.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberAccount").getter(ViolationDetail.getter(ViolationDetail::memberAccount)).setter(ViolationDetail.setter(Builder::memberAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccount").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ViolationDetail.getter(ViolationDetail::resourceId)).setter(ViolationDetail.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ViolationDetail.getter(ViolationDetail::resourceType)).setter(ViolationDetail.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<ResourceViolation>> RESOURCE_VIOLATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceViolations").getter(ViolationDetail.getter(ViolationDetail::resourceViolations)).setter(ViolationDetail.setter(Builder::resourceViolations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceViolations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(ViolationDetail.getter(ViolationDetail::resourceTags)).setter(ViolationDetail.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceDescription").getter(ViolationDetail.getter(ViolationDetail::resourceDescription)).setter(ViolationDetail.setter(Builder::resourceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, MEMBER_ACCOUNT_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_VIOLATIONS_FIELD, RESOURCE_TAGS_FIELD, RESOURCE_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ViolationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final String memberAccount;
    private final String resourceId;
    private final String resourceType;
    private final List<ResourceViolation> resourceViolations;
    private final List<Tag> resourceTags;
    private final String resourceDescription;

    private ViolationDetail(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.memberAccount = builder.memberAccount;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceViolations = builder.resourceViolations;
        this.resourceTags = builder.resourceTags;
        this.resourceDescription = builder.resourceDescription;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String memberAccount() {
        return this.memberAccount;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasResourceViolations() {
        return this.resourceViolations != null && !(this.resourceViolations instanceof SdkAutoConstructList);
    }

    public final List<ResourceViolation> resourceViolations() {
        return this.resourceViolations;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> resourceTags() {
        return this.resourceTags;
    }

    public final String resourceDescription() {
        return this.resourceDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceViolations() ? this.resourceViolations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViolationDetail)) {
            return false;
        }
        ViolationDetail other = (ViolationDetail)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.memberAccount(), other.memberAccount()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && this.hasResourceViolations() == other.hasResourceViolations() && Objects.equals(this.resourceViolations(), other.resourceViolations()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.resourceDescription(), other.resourceDescription());
    }

    public final String toString() {
        return ToString.builder((String)"ViolationDetail").add("PolicyId", (Object)this.policyId()).add("MemberAccount", (Object)this.memberAccount()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceType()).add("ResourceViolations", this.hasResourceViolations() ? this.resourceViolations() : null).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("ResourceDescription", (Object)this.resourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "MemberAccount": {
                return Optional.ofNullable(clazz.cast(this.memberAccount()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceViolations": {
                return Optional.ofNullable(clazz.cast(this.resourceViolations()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "ResourceDescription": {
                return Optional.ofNullable(clazz.cast(this.resourceDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("MemberAccount", MEMBER_ACCOUNT_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceViolations", RESOURCE_VIOLATIONS_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("ResourceDescription", RESOURCE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViolationDetail, T> g) {
        return obj -> g.apply((ViolationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String memberAccount;
        private String resourceId;
        private String resourceType;
        private List<ResourceViolation> resourceViolations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private String resourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ViolationDetail model) {
            this.policyId(model.policyId);
            this.memberAccount(model.memberAccount);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceViolations(model.resourceViolations);
            this.resourceTags(model.resourceTags);
            this.resourceDescription(model.resourceDescription);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getMemberAccount() {
            return this.memberAccount;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        @Override
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final List<ResourceViolation.Builder> getResourceViolations() {
            List<ResourceViolation.Builder> result = ResourceViolationsCopier.copyToBuilder(this.resourceViolations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceViolations(Collection<ResourceViolation.BuilderImpl> resourceViolations) {
            this.resourceViolations = ResourceViolationsCopier.copyFromBuilder(resourceViolations);
        }

        @Override
        public final Builder resourceViolations(Collection<ResourceViolation> resourceViolations) {
            this.resourceViolations = ResourceViolationsCopier.copy(resourceViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceViolations(ResourceViolation ... resourceViolations) {
            this.resourceViolations(Arrays.asList(resourceViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceViolations(Consumer<ResourceViolation.Builder> ... resourceViolations) {
            this.resourceViolations(Stream.of(resourceViolations).map(c -> (ResourceViolation)((ResourceViolation.Builder)ResourceViolation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getResourceTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<Tag.BuilderImpl> resourceTags) {
            this.resourceTags = TagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<Tag> resourceTags) {
            this.resourceTags = TagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Tag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<Tag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceDescription() {
            return this.resourceDescription;
        }

        public final void setResourceDescription(String resourceDescription) {
            this.resourceDescription = resourceDescription;
        }

        @Override
        public final Builder resourceDescription(String resourceDescription) {
            this.resourceDescription = resourceDescription;
            return this;
        }

        public ViolationDetail build() {
            return new ViolationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViolationDetail> {
        public Builder policyId(String var1);

        public Builder memberAccount(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceViolations(Collection<ResourceViolation> var1);

        public Builder resourceViolations(ResourceViolation ... var1);

        public Builder resourceViolations(Consumer<ResourceViolation.Builder> ... var1);

        public Builder resourceTags(Collection<Tag> var1);

        public Builder resourceTags(Tag ... var1);

        public Builder resourceTags(Consumer<Tag.Builder> ... var1);

        public Builder resourceDescription(String var1);
    }
}

