/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AccountScope;
import software.amazon.awssdk.services.fms.model.OrganizationalUnitScope;
import software.amazon.awssdk.services.fms.model.PolicyTypeScope;
import software.amazon.awssdk.services.fms.model.RegionScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdminScope> {
    private static final SdkField<AccountScope> ACCOUNT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountScope").getter(AdminScope.getter(AdminScope::accountScope)).setter(AdminScope.setter(Builder::accountScope)).constructor(AccountScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()}).build();
    private static final SdkField<OrganizationalUnitScope> ORGANIZATIONAL_UNIT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationalUnitScope").getter(AdminScope.getter(AdminScope::organizationalUnitScope)).setter(AdminScope.setter(Builder::organizationalUnitScope)).constructor(OrganizationalUnitScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitScope").build()}).build();
    private static final SdkField<RegionScope> REGION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegionScope").getter(AdminScope.getter(AdminScope::regionScope)).setter(AdminScope.setter(Builder::regionScope)).constructor(RegionScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionScope").build()}).build();
    private static final SdkField<PolicyTypeScope> POLICY_TYPE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyTypeScope").getter(AdminScope.getter(AdminScope::policyTypeScope)).setter(AdminScope.setter(Builder::policyTypeScope)).constructor(PolicyTypeScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD, ORGANIZATIONAL_UNIT_SCOPE_FIELD, REGION_SCOPE_FIELD, POLICY_TYPE_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdminScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AccountScope accountScope;
    private final OrganizationalUnitScope organizationalUnitScope;
    private final RegionScope regionScope;
    private final PolicyTypeScope policyTypeScope;

    private AdminScope(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.organizationalUnitScope = builder.organizationalUnitScope;
        this.regionScope = builder.regionScope;
        this.policyTypeScope = builder.policyTypeScope;
    }

    public final AccountScope accountScope() {
        return this.accountScope;
    }

    public final OrganizationalUnitScope organizationalUnitScope() {
        return this.organizationalUnitScope;
    }

    public final RegionScope regionScope() {
        return this.regionScope;
    }

    public final PolicyTypeScope policyTypeScope() {
        return this.policyTypeScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminScope)) {
            return false;
        }
        AdminScope other = (AdminScope)obj;
        return Objects.equals(this.accountScope(), other.accountScope()) && Objects.equals(this.organizationalUnitScope(), other.organizationalUnitScope()) && Objects.equals(this.regionScope(), other.regionScope()) && Objects.equals(this.policyTypeScope(), other.policyTypeScope());
    }

    public final String toString() {
        return ToString.builder((String)"AdminScope").add("AccountScope", (Object)this.accountScope()).add("OrganizationalUnitScope", (Object)this.organizationalUnitScope()).add("RegionScope", (Object)this.regionScope()).add("PolicyTypeScope", (Object)this.policyTypeScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScope()));
            }
            case "OrganizationalUnitScope": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitScope()));
            }
            case "RegionScope": {
                return Optional.ofNullable(clazz.cast(this.regionScope()));
            }
            case "PolicyTypeScope": {
                return Optional.ofNullable(clazz.cast(this.policyTypeScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountScope", ACCOUNT_SCOPE_FIELD);
        map.put("OrganizationalUnitScope", ORGANIZATIONAL_UNIT_SCOPE_FIELD);
        map.put("RegionScope", REGION_SCOPE_FIELD);
        map.put("PolicyTypeScope", POLICY_TYPE_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdminScope, T> g) {
        return obj -> g.apply((AdminScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccountScope accountScope;
        private OrganizationalUnitScope organizationalUnitScope;
        private RegionScope regionScope;
        private PolicyTypeScope policyTypeScope;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminScope model) {
            this.accountScope(model.accountScope);
            this.organizationalUnitScope(model.organizationalUnitScope);
            this.regionScope(model.regionScope);
            this.policyTypeScope(model.policyTypeScope);
        }

        public final AccountScope.Builder getAccountScope() {
            return this.accountScope != null ? this.accountScope.toBuilder() : null;
        }

        public final void setAccountScope(AccountScope.BuilderImpl accountScope) {
            this.accountScope = accountScope != null ? accountScope.build() : null;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        public final OrganizationalUnitScope.Builder getOrganizationalUnitScope() {
            return this.organizationalUnitScope != null ? this.organizationalUnitScope.toBuilder() : null;
        }

        public final void setOrganizationalUnitScope(OrganizationalUnitScope.BuilderImpl organizationalUnitScope) {
            this.organizationalUnitScope = organizationalUnitScope != null ? organizationalUnitScope.build() : null;
        }

        @Override
        public final Builder organizationalUnitScope(OrganizationalUnitScope organizationalUnitScope) {
            this.organizationalUnitScope = organizationalUnitScope;
            return this;
        }

        public final RegionScope.Builder getRegionScope() {
            return this.regionScope != null ? this.regionScope.toBuilder() : null;
        }

        public final void setRegionScope(RegionScope.BuilderImpl regionScope) {
            this.regionScope = regionScope != null ? regionScope.build() : null;
        }

        @Override
        public final Builder regionScope(RegionScope regionScope) {
            this.regionScope = regionScope;
            return this;
        }

        public final PolicyTypeScope.Builder getPolicyTypeScope() {
            return this.policyTypeScope != null ? this.policyTypeScope.toBuilder() : null;
        }

        public final void setPolicyTypeScope(PolicyTypeScope.BuilderImpl policyTypeScope) {
            this.policyTypeScope = policyTypeScope != null ? policyTypeScope.build() : null;
        }

        @Override
        public final Builder policyTypeScope(PolicyTypeScope policyTypeScope) {
            this.policyTypeScope = policyTypeScope;
            return this;
        }

        public AdminScope build() {
            return new AdminScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdminScope> {
        public Builder accountScope(AccountScope var1);

        default public Builder accountScope(Consumer<AccountScope.Builder> accountScope) {
            return this.accountScope((AccountScope)((AccountScope.Builder)AccountScope.builder().applyMutation(accountScope)).build());
        }

        public Builder organizationalUnitScope(OrganizationalUnitScope var1);

        default public Builder organizationalUnitScope(Consumer<OrganizationalUnitScope.Builder> organizationalUnitScope) {
            return this.organizationalUnitScope((OrganizationalUnitScope)((OrganizationalUnitScope.Builder)OrganizationalUnitScope.builder().applyMutation(organizationalUnitScope)).build());
        }

        public Builder regionScope(RegionScope var1);

        default public Builder regionScope(Consumer<RegionScope.Builder> regionScope) {
            return this.regionScope((RegionScope)((RegionScope.Builder)RegionScope.builder().applyMutation(regionScope)).build());
        }

        public Builder policyTypeScope(PolicyTypeScope var1);

        default public Builder policyTypeScope(Consumer<PolicyTypeScope.Builder> policyTypeScope) {
            return this.policyTypeScope((PolicyTypeScope)((PolicyTypeScope.Builder)PolicyTypeScope.builder().applyMutation(policyTypeScope)).build());
        }
    }
}

