/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.Route;
import software.amazon.awssdk.services.fms.model.RoutesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallUnexpectedGatewayRoutesViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallUnexpectedGatewayRoutesViolation> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayId").getter(NetworkFirewallUnexpectedGatewayRoutesViolation.getter(NetworkFirewallUnexpectedGatewayRoutesViolation::gatewayId)).setter(NetworkFirewallUnexpectedGatewayRoutesViolation.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViolatingRoutes").getter(NetworkFirewallUnexpectedGatewayRoutesViolation.getter(NetworkFirewallUnexpectedGatewayRoutesViolation::violatingRoutes)).setter(NetworkFirewallUnexpectedGatewayRoutesViolation.setter(Builder::violatingRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(NetworkFirewallUnexpectedGatewayRoutesViolation.getter(NetworkFirewallUnexpectedGatewayRoutesViolation::routeTableId)).setter(NetworkFirewallUnexpectedGatewayRoutesViolation.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NetworkFirewallUnexpectedGatewayRoutesViolation.getter(NetworkFirewallUnexpectedGatewayRoutesViolation::vpcId)).setter(NetworkFirewallUnexpectedGatewayRoutesViolation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, VIOLATING_ROUTES_FIELD, ROUTE_TABLE_ID_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkFirewallUnexpectedGatewayRoutesViolation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gatewayId;
    private final List<Route> violatingRoutes;
    private final String routeTableId;
    private final String vpcId;

    private NetworkFirewallUnexpectedGatewayRoutesViolation(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.violatingRoutes = builder.violatingRoutes;
        this.routeTableId = builder.routeTableId;
        this.vpcId = builder.vpcId;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final boolean hasViolatingRoutes() {
        return this.violatingRoutes != null && !(this.violatingRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> violatingRoutes() {
        return this.violatingRoutes;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolatingRoutes() ? this.violatingRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallUnexpectedGatewayRoutesViolation)) {
            return false;
        }
        NetworkFirewallUnexpectedGatewayRoutesViolation other = (NetworkFirewallUnexpectedGatewayRoutesViolation)obj;
        return Objects.equals(this.gatewayId(), other.gatewayId()) && this.hasViolatingRoutes() == other.hasViolatingRoutes() && Objects.equals(this.violatingRoutes(), other.violatingRoutes()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallUnexpectedGatewayRoutesViolation").add("GatewayId", (Object)this.gatewayId()).add("ViolatingRoutes", this.hasViolatingRoutes() ? this.violatingRoutes() : null).add("RouteTableId", (Object)this.routeTableId()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "ViolatingRoutes": {
                return Optional.ofNullable(clazz.cast(this.violatingRoutes()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallUnexpectedGatewayRoutesViolation, T> g) {
        return obj -> g.apply((NetworkFirewallUnexpectedGatewayRoutesViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayId;
        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();
        private String routeTableId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallUnexpectedGatewayRoutesViolation model) {
            this.gatewayId(model.gatewayId);
            this.violatingRoutes(model.violatingRoutes);
            this.routeTableId(model.routeTableId);
            this.vpcId(model.vpcId);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route ... violatingRoutes) {
            this.violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder> ... violatingRoutes) {
            this.violatingRoutes(Stream.of(violatingRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public NetworkFirewallUnexpectedGatewayRoutesViolation build() {
            return new NetworkFirewallUnexpectedGatewayRoutesViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallUnexpectedGatewayRoutesViolation> {
        public Builder gatewayId(String var1);

        public Builder violatingRoutes(Collection<Route> var1);

        public Builder violatingRoutes(Route ... var1);

        public Builder violatingRoutes(Consumer<Route.Builder> ... var1);

        public Builder routeTableId(String var1);

        public Builder vpcId(String var1);
    }
}

