/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType;
import software.amazon.awssdk.services.fms.model.CustomerPolicyScopeMapCopier;
import software.amazon.awssdk.services.fms.model.CustomerPolicyStatus;
import software.amazon.awssdk.services.fms.model.ResourceSetIdsCopier;
import software.amazon.awssdk.services.fms.model.ResourceTag;
import software.amazon.awssdk.services.fms.model.ResourceTagsCopier;
import software.amazon.awssdk.services.fms.model.ResourceTypeListCopier;
import software.amazon.awssdk.services.fms.model.SecurityServicePolicyData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Policy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Policy> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(Policy.getter(Policy::policyId)).setter(Policy.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(Policy.getter(Policy::policyName)).setter(Policy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyUpdateToken").getter(Policy.getter(Policy::policyUpdateToken)).setter(Policy.setter(Builder::policyUpdateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyUpdateToken").build()}).build();
    private static final SdkField<SecurityServicePolicyData> SECURITY_SERVICE_POLICY_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityServicePolicyData").getter(Policy.getter(Policy::securityServicePolicyData)).setter(Policy.setter(Builder::securityServicePolicyData)).constructor(SecurityServicePolicyData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityServicePolicyData").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(Policy.getter(Policy::resourceType)).setter(Policy.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypeList").getter(Policy.getter(Policy::resourceTypeList)).setter(Policy.setter(Builder::resourceTypeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(Policy.getter(Policy::resourceTags)).setter(Policy.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EXCLUDE_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeResourceTags").getter(Policy.getter(Policy::excludeResourceTags)).setter(Policy.setter(Builder::excludeResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeResourceTags").build()}).build();
    private static final SdkField<Boolean> REMEDIATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemediationEnabled").getter(Policy.getter(Policy::remediationEnabled)).setter(Policy.setter(Builder::remediationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationEnabled").build()}).build();
    private static final SdkField<Boolean> DELETE_UNUSED_FM_MANAGED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteUnusedFMManagedResources").getter(Policy.getter(Policy::deleteUnusedFMManagedResources)).setter(Policy.setter(Builder::deleteUnusedFMManagedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteUnusedFMManagedResources").build()}).build();
    private static final SdkField<Map<String, List<String>>> INCLUDE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IncludeMap").getter(Policy.getter(Policy::includeMapAsStrings)).setter(Policy.setter(Builder::includeMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> EXCLUDE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExcludeMap").getter(Policy.getter(Policy::excludeMapAsStrings)).setter(Policy.setter(Builder::excludeMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_SET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceSetIds").getter(Policy.getter(Policy::resourceSetIds)).setter(Policy.setter(Builder::resourceSetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDescription").getter(Policy.getter(Policy::policyDescription)).setter(Policy.setter(Builder::policyDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDescription").build()}).build();
    private static final SdkField<String> POLICY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyStatus").getter(Policy.getter(Policy::policyStatusAsString)).setter(Policy.setter(Builder::policyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, POLICY_NAME_FIELD, POLICY_UPDATE_TOKEN_FIELD, SECURITY_SERVICE_POLICY_DATA_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TYPE_LIST_FIELD, RESOURCE_TAGS_FIELD, EXCLUDE_RESOURCE_TAGS_FIELD, REMEDIATION_ENABLED_FIELD, DELETE_UNUSED_FM_MANAGED_RESOURCES_FIELD, INCLUDE_MAP_FIELD, EXCLUDE_MAP_FIELD, RESOURCE_SET_IDS_FIELD, POLICY_DESCRIPTION_FIELD, POLICY_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Policy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final String policyName;
    private final String policyUpdateToken;
    private final SecurityServicePolicyData securityServicePolicyData;
    private final String resourceType;
    private final List<String> resourceTypeList;
    private final List<ResourceTag> resourceTags;
    private final Boolean excludeResourceTags;
    private final Boolean remediationEnabled;
    private final Boolean deleteUnusedFMManagedResources;
    private final Map<String, List<String>> includeMap;
    private final Map<String, List<String>> excludeMap;
    private final List<String> resourceSetIds;
    private final String policyDescription;
    private final String policyStatus;

    private Policy(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.policyUpdateToken = builder.policyUpdateToken;
        this.securityServicePolicyData = builder.securityServicePolicyData;
        this.resourceType = builder.resourceType;
        this.resourceTypeList = builder.resourceTypeList;
        this.resourceTags = builder.resourceTags;
        this.excludeResourceTags = builder.excludeResourceTags;
        this.remediationEnabled = builder.remediationEnabled;
        this.deleteUnusedFMManagedResources = builder.deleteUnusedFMManagedResources;
        this.includeMap = builder.includeMap;
        this.excludeMap = builder.excludeMap;
        this.resourceSetIds = builder.resourceSetIds;
        this.policyDescription = builder.policyDescription;
        this.policyStatus = builder.policyStatus;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyUpdateToken() {
        return this.policyUpdateToken;
    }

    public final SecurityServicePolicyData securityServicePolicyData() {
        return this.securityServicePolicyData;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasResourceTypeList() {
        return this.resourceTypeList != null && !(this.resourceTypeList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypeList() {
        return this.resourceTypeList;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final Boolean excludeResourceTags() {
        return this.excludeResourceTags;
    }

    public final Boolean remediationEnabled() {
        return this.remediationEnabled;
    }

    public final Boolean deleteUnusedFMManagedResources() {
        return this.deleteUnusedFMManagedResources;
    }

    public final Map<CustomerPolicyScopeIdType, List<String>> includeMap() {
        return CustomerPolicyScopeMapCopier.copyStringToEnum(this.includeMap);
    }

    public final boolean hasIncludeMap() {
        return this.includeMap != null && !(this.includeMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> includeMapAsStrings() {
        return this.includeMap;
    }

    public final Map<CustomerPolicyScopeIdType, List<String>> excludeMap() {
        return CustomerPolicyScopeMapCopier.copyStringToEnum(this.excludeMap);
    }

    public final boolean hasExcludeMap() {
        return this.excludeMap != null && !(this.excludeMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> excludeMapAsStrings() {
        return this.excludeMap;
    }

    public final boolean hasResourceSetIds() {
        return this.resourceSetIds != null && !(this.resourceSetIds instanceof SdkAutoConstructList);
    }

    public final List<String> resourceSetIds() {
        return this.resourceSetIds;
    }

    public final String policyDescription() {
        return this.policyDescription;
    }

    public final CustomerPolicyStatus policyStatus() {
        return CustomerPolicyStatus.fromValue(this.policyStatus);
    }

    public final String policyStatusAsString() {
        return this.policyStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyUpdateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityServicePolicyData());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeList() ? this.resourceTypeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeResourceTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteUnusedFMManagedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeMap() ? this.includeMapAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeMap() ? this.excludeMapAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceSetIds() ? this.resourceSetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyUpdateToken(), other.policyUpdateToken()) && Objects.equals(this.securityServicePolicyData(), other.securityServicePolicyData()) && Objects.equals(this.resourceType(), other.resourceType()) && this.hasResourceTypeList() == other.hasResourceTypeList() && Objects.equals(this.resourceTypeList(), other.resourceTypeList()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.excludeResourceTags(), other.excludeResourceTags()) && Objects.equals(this.remediationEnabled(), other.remediationEnabled()) && Objects.equals(this.deleteUnusedFMManagedResources(), other.deleteUnusedFMManagedResources()) && this.hasIncludeMap() == other.hasIncludeMap() && Objects.equals(this.includeMapAsStrings(), other.includeMapAsStrings()) && this.hasExcludeMap() == other.hasExcludeMap() && Objects.equals(this.excludeMapAsStrings(), other.excludeMapAsStrings()) && this.hasResourceSetIds() == other.hasResourceSetIds() && Objects.equals(this.resourceSetIds(), other.resourceSetIds()) && Objects.equals(this.policyDescription(), other.policyDescription()) && Objects.equals(this.policyStatusAsString(), other.policyStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Policy").add("PolicyId", (Object)this.policyId()).add("PolicyName", (Object)this.policyName()).add("PolicyUpdateToken", (Object)this.policyUpdateToken()).add("SecurityServicePolicyData", (Object)this.securityServicePolicyData()).add("ResourceType", (Object)this.resourceType()).add("ResourceTypeList", this.hasResourceTypeList() ? this.resourceTypeList() : null).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("ExcludeResourceTags", (Object)this.excludeResourceTags()).add("RemediationEnabled", (Object)this.remediationEnabled()).add("DeleteUnusedFMManagedResources", (Object)this.deleteUnusedFMManagedResources()).add("IncludeMap", this.hasIncludeMap() ? this.includeMapAsStrings() : null).add("ExcludeMap", this.hasExcludeMap() ? this.excludeMapAsStrings() : null).add("ResourceSetIds", this.hasResourceSetIds() ? this.resourceSetIds() : null).add("PolicyDescription", (Object)this.policyDescription()).add("PolicyStatus", (Object)this.policyStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyUpdateToken": {
                return Optional.ofNullable(clazz.cast(this.policyUpdateToken()));
            }
            case "SecurityServicePolicyData": {
                return Optional.ofNullable(clazz.cast(this.securityServicePolicyData()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceTypeList": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeList()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "ExcludeResourceTags": {
                return Optional.ofNullable(clazz.cast(this.excludeResourceTags()));
            }
            case "RemediationEnabled": {
                return Optional.ofNullable(clazz.cast(this.remediationEnabled()));
            }
            case "DeleteUnusedFMManagedResources": {
                return Optional.ofNullable(clazz.cast(this.deleteUnusedFMManagedResources()));
            }
            case "IncludeMap": {
                return Optional.ofNullable(clazz.cast(this.includeMapAsStrings()));
            }
            case "ExcludeMap": {
                return Optional.ofNullable(clazz.cast(this.excludeMapAsStrings()));
            }
            case "ResourceSetIds": {
                return Optional.ofNullable(clazz.cast(this.resourceSetIds()));
            }
            case "PolicyDescription": {
                return Optional.ofNullable(clazz.cast(this.policyDescription()));
            }
            case "PolicyStatus": {
                return Optional.ofNullable(clazz.cast(this.policyStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("PolicyUpdateToken", POLICY_UPDATE_TOKEN_FIELD);
        map.put("SecurityServicePolicyData", SECURITY_SERVICE_POLICY_DATA_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceTypeList", RESOURCE_TYPE_LIST_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("ExcludeResourceTags", EXCLUDE_RESOURCE_TAGS_FIELD);
        map.put("RemediationEnabled", REMEDIATION_ENABLED_FIELD);
        map.put("DeleteUnusedFMManagedResources", DELETE_UNUSED_FM_MANAGED_RESOURCES_FIELD);
        map.put("IncludeMap", INCLUDE_MAP_FIELD);
        map.put("ExcludeMap", EXCLUDE_MAP_FIELD);
        map.put("ResourceSetIds", RESOURCE_SET_IDS_FIELD);
        map.put("PolicyDescription", POLICY_DESCRIPTION_FIELD);
        map.put("PolicyStatus", POLICY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Policy, T> g) {
        return obj -> g.apply((Policy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String policyName;
        private String policyUpdateToken;
        private SecurityServicePolicyData securityServicePolicyData;
        private String resourceType;
        private List<String> resourceTypeList = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private Boolean excludeResourceTags;
        private Boolean remediationEnabled;
        private Boolean deleteUnusedFMManagedResources;
        private Map<String, List<String>> includeMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> excludeMap = DefaultSdkAutoConstructMap.getInstance();
        private List<String> resourceSetIds = DefaultSdkAutoConstructList.getInstance();
        private String policyDescription;
        private String policyStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            this.policyId(model.policyId);
            this.policyName(model.policyName);
            this.policyUpdateToken(model.policyUpdateToken);
            this.securityServicePolicyData(model.securityServicePolicyData);
            this.resourceType(model.resourceType);
            this.resourceTypeList(model.resourceTypeList);
            this.resourceTags(model.resourceTags);
            this.excludeResourceTags(model.excludeResourceTags);
            this.remediationEnabled(model.remediationEnabled);
            this.deleteUnusedFMManagedResources(model.deleteUnusedFMManagedResources);
            this.includeMapWithStrings(model.includeMap);
            this.excludeMapWithStrings(model.excludeMap);
            this.resourceSetIds(model.resourceSetIds);
            this.policyDescription(model.policyDescription);
            this.policyStatus(model.policyStatus);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyUpdateToken() {
            return this.policyUpdateToken;
        }

        public final void setPolicyUpdateToken(String policyUpdateToken) {
            this.policyUpdateToken = policyUpdateToken;
        }

        @Override
        public final Builder policyUpdateToken(String policyUpdateToken) {
            this.policyUpdateToken = policyUpdateToken;
            return this;
        }

        public final SecurityServicePolicyData.Builder getSecurityServicePolicyData() {
            return this.securityServicePolicyData != null ? this.securityServicePolicyData.toBuilder() : null;
        }

        public final void setSecurityServicePolicyData(SecurityServicePolicyData.BuilderImpl securityServicePolicyData) {
            this.securityServicePolicyData = securityServicePolicyData != null ? securityServicePolicyData.build() : null;
        }

        @Override
        public final Builder securityServicePolicyData(SecurityServicePolicyData securityServicePolicyData) {
            this.securityServicePolicyData = securityServicePolicyData;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getResourceTypeList() {
            if (this.resourceTypeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypeList;
        }

        public final void setResourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
        }

        @Override
        public final Builder resourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeList(String ... resourceTypeList) {
            this.resourceTypeList(Arrays.asList(resourceTypeList));
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getExcludeResourceTags() {
            return this.excludeResourceTags;
        }

        public final void setExcludeResourceTags(Boolean excludeResourceTags) {
            this.excludeResourceTags = excludeResourceTags;
        }

        @Override
        public final Builder excludeResourceTags(Boolean excludeResourceTags) {
            this.excludeResourceTags = excludeResourceTags;
            return this;
        }

        public final Boolean getRemediationEnabled() {
            return this.remediationEnabled;
        }

        public final void setRemediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
        }

        @Override
        public final Builder remediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
            return this;
        }

        public final Boolean getDeleteUnusedFMManagedResources() {
            return this.deleteUnusedFMManagedResources;
        }

        public final void setDeleteUnusedFMManagedResources(Boolean deleteUnusedFMManagedResources) {
            this.deleteUnusedFMManagedResources = deleteUnusedFMManagedResources;
        }

        @Override
        public final Builder deleteUnusedFMManagedResources(Boolean deleteUnusedFMManagedResources) {
            this.deleteUnusedFMManagedResources = deleteUnusedFMManagedResources;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIncludeMap() {
            if (this.includeMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.includeMap;
        }

        public final void setIncludeMap(Map<String, ? extends Collection<String>> includeMap) {
            this.includeMap = CustomerPolicyScopeMapCopier.copy(includeMap);
        }

        @Override
        public final Builder includeMapWithStrings(Map<String, ? extends Collection<String>> includeMap) {
            this.includeMap = CustomerPolicyScopeMapCopier.copy(includeMap);
            return this;
        }

        @Override
        public final Builder includeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> includeMap) {
            this.includeMap = CustomerPolicyScopeMapCopier.copyEnumToString(includeMap);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getExcludeMap() {
            if (this.excludeMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.excludeMap;
        }

        public final void setExcludeMap(Map<String, ? extends Collection<String>> excludeMap) {
            this.excludeMap = CustomerPolicyScopeMapCopier.copy(excludeMap);
        }

        @Override
        public final Builder excludeMapWithStrings(Map<String, ? extends Collection<String>> excludeMap) {
            this.excludeMap = CustomerPolicyScopeMapCopier.copy(excludeMap);
            return this;
        }

        @Override
        public final Builder excludeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> excludeMap) {
            this.excludeMap = CustomerPolicyScopeMapCopier.copyEnumToString(excludeMap);
            return this;
        }

        public final Collection<String> getResourceSetIds() {
            if (this.resourceSetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceSetIds;
        }

        public final void setResourceSetIds(Collection<String> resourceSetIds) {
            this.resourceSetIds = ResourceSetIdsCopier.copy(resourceSetIds);
        }

        @Override
        public final Builder resourceSetIds(Collection<String> resourceSetIds) {
            this.resourceSetIds = ResourceSetIdsCopier.copy(resourceSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSetIds(String ... resourceSetIds) {
            this.resourceSetIds(Arrays.asList(resourceSetIds));
            return this;
        }

        public final String getPolicyDescription() {
            return this.policyDescription;
        }

        public final void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        @Override
        public final Builder policyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        public final String getPolicyStatus() {
            return this.policyStatus;
        }

        public final void setPolicyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
        }

        @Override
        public final Builder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        @Override
        public final Builder policyStatus(CustomerPolicyStatus policyStatus) {
            this.policyStatus(policyStatus == null ? null : policyStatus.toString());
            return this;
        }

        public Policy build() {
            return new Policy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Policy> {
        public Builder policyId(String var1);

        public Builder policyName(String var1);

        public Builder policyUpdateToken(String var1);

        public Builder securityServicePolicyData(SecurityServicePolicyData var1);

        default public Builder securityServicePolicyData(Consumer<SecurityServicePolicyData.Builder> securityServicePolicyData) {
            return this.securityServicePolicyData((SecurityServicePolicyData)((SecurityServicePolicyData.Builder)SecurityServicePolicyData.builder().applyMutation(securityServicePolicyData)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceTypeList(Collection<String> var1);

        public Builder resourceTypeList(String ... var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder excludeResourceTags(Boolean var1);

        public Builder remediationEnabled(Boolean var1);

        public Builder deleteUnusedFMManagedResources(Boolean var1);

        public Builder includeMapWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder includeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> var1);

        public Builder excludeMapWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder excludeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> var1);

        public Builder resourceSetIds(Collection<String> var1);

        public Builder resourceSetIds(String ... var1);

        public Builder policyDescription(String var1);

        public Builder policyStatus(String var1);

        public Builder policyStatus(CustomerPolicyStatus var1);
    }
}

