/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ViolationReason {
    WEB_ACL_MISSING_RULE_GROUP("WEB_ACL_MISSING_RULE_GROUP"),

    RESOURCE_MISSING_WEB_ACL("RESOURCE_MISSING_WEB_ACL"),

    RESOURCE_INCORRECT_WEB_ACL("RESOURCE_INCORRECT_WEB_ACL"),

    RESOURCE_MISSING_SHIELD_PROTECTION("RESOURCE_MISSING_SHIELD_PROTECTION"),

    RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION("RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION"),

    RESOURCE_MISSING_SECURITY_GROUP("RESOURCE_MISSING_SECURITY_GROUP"),

    RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP("RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP"),

    SECURITY_GROUP_UNUSED("SECURITY_GROUP_UNUSED"),

    SECURITY_GROUP_REDUNDANT("SECURITY_GROUP_REDUNDANT"),

    FMS_CREATED_SECURITY_GROUP_EDITED("FMS_CREATED_SECURITY_GROUP_EDITED"),

    MISSING_FIREWALL("MISSING_FIREWALL"),

    MISSING_FIREWALL_SUBNET_IN_AZ("MISSING_FIREWALL_SUBNET_IN_AZ"),

    MISSING_EXPECTED_ROUTE_TABLE("MISSING_EXPECTED_ROUTE_TABLE"),

    NETWORK_FIREWALL_POLICY_MODIFIED("NETWORK_FIREWALL_POLICY_MODIFIED"),

    FIREWALL_SUBNET_IS_OUT_OF_SCOPE("FIREWALL_SUBNET_IS_OUT_OF_SCOPE"),

    INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE("INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE"),

    FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE("FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE"),

    UNEXPECTED_FIREWALL_ROUTES("UNEXPECTED_FIREWALL_ROUTES"),

    UNEXPECTED_TARGET_GATEWAY_ROUTES("UNEXPECTED_TARGET_GATEWAY_ROUTES"),

    TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY("TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY"),

    INVALID_ROUTE_CONFIGURATION("INVALID_ROUTE_CONFIGURATION"),

    MISSING_TARGET_GATEWAY("MISSING_TARGET_GATEWAY"),

    INTERNET_TRAFFIC_NOT_INSPECTED("INTERNET_TRAFFIC_NOT_INSPECTED"),

    BLACK_HOLE_ROUTE_DETECTED("BLACK_HOLE_ROUTE_DETECTED"),

    BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET("BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET"),

    RESOURCE_MISSING_DNS_FIREWALL("RESOURCE_MISSING_DNS_FIREWALL"),

    ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT("ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT"),

    FIREWALL_SUBNET_MISSING_VPCE_ENDPOINT("FIREWALL_SUBNET_MISSING_VPCE_ENDPOINT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ViolationReason> VALUE_MAP = EnumUtils.uniqueIndex(ViolationReason.class,
            ViolationReason::toString);

    private final String value;

    private ViolationReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ViolationReason corresponding to the value
     */
    public static ViolationReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ViolationReason}s
     */
    public static Set<ViolationReason> knownValues() {
        Set<ViolationReason> knownValues = EnumSet.allOf(ViolationReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
