/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ResourceSetStatus;
import software.amazon.awssdk.services.fms.model.ResourceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSet> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResourceSet.getter(ResourceSet::id)).setter(ResourceSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResourceSet.getter(ResourceSet::name)).setter(ResourceSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ResourceSet.getter(ResourceSet::description)).setter(ResourceSet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(ResourceSet.getter(ResourceSet::updateToken)).setter(ResourceSet.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypeList").getter(ResourceSet.getter(ResourceSet::resourceTypeList)).setter(ResourceSet.setter(Builder::resourceTypeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(ResourceSet.getter(ResourceSet::lastUpdateTime)).setter(ResourceSet.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final SdkField<String> RESOURCE_SET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetStatus").getter(ResourceSet.getter(ResourceSet::resourceSetStatusAsString)).setter(ResourceSet.setter(Builder::resourceSetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, UPDATE_TOKEN_FIELD, RESOURCE_TYPE_LIST_FIELD, LAST_UPDATE_TIME_FIELD, RESOURCE_SET_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String updateToken;
    private final List<String> resourceTypeList;
    private final Instant lastUpdateTime;
    private final String resourceSetStatus;

    private ResourceSet(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.updateToken = builder.updateToken;
        this.resourceTypeList = builder.resourceTypeList;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.resourceSetStatus = builder.resourceSetStatus;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public final boolean hasResourceTypeList() {
        return this.resourceTypeList != null && !(this.resourceTypeList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypeList() {
        return this.resourceTypeList;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final ResourceSetStatus resourceSetStatus() {
        return ResourceSetStatus.fromValue(this.resourceSetStatus);
    }

    public final String resourceSetStatusAsString() {
        return this.resourceSetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeList() ? this.resourceTypeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSet)) {
            return false;
        }
        ResourceSet other = (ResourceSet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updateToken(), other.updateToken()) && this.hasResourceTypeList() == other.hasResourceTypeList() && Objects.equals(this.resourceTypeList(), other.resourceTypeList()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.resourceSetStatusAsString(), other.resourceSetStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSet").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("UpdateToken", (Object)this.updateToken()).add("ResourceTypeList", this.hasResourceTypeList() ? this.resourceTypeList() : null).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("ResourceSetStatus", (Object)this.resourceSetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
            case "ResourceTypeList": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeList()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "ResourceSetStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceSetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSet, T> g) {
        return obj -> g.apply((ResourceSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String updateToken;
        private List<String> resourceTypeList = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdateTime;
        private String resourceSetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSet model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.updateToken(model.updateToken);
            this.resourceTypeList(model.resourceTypeList);
            this.lastUpdateTime(model.lastUpdateTime);
            this.resourceSetStatus(model.resourceSetStatus);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final Collection<String> getResourceTypeList() {
            if (this.resourceTypeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypeList;
        }

        public final void setResourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
        }

        @Override
        public final Builder resourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeList(String ... resourceTypeList) {
            this.resourceTypeList(Arrays.asList(resourceTypeList));
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getResourceSetStatus() {
            return this.resourceSetStatus;
        }

        public final void setResourceSetStatus(String resourceSetStatus) {
            this.resourceSetStatus = resourceSetStatus;
        }

        @Override
        public final Builder resourceSetStatus(String resourceSetStatus) {
            this.resourceSetStatus = resourceSetStatus;
            return this;
        }

        @Override
        public final Builder resourceSetStatus(ResourceSetStatus resourceSetStatus) {
            this.resourceSetStatus(resourceSetStatus == null ? null : resourceSetStatus.toString());
            return this;
        }

        public ResourceSet build() {
            return new ResourceSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSet> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder updateToken(String var1);

        public Builder resourceTypeList(Collection<String> var1);

        public Builder resourceTypeList(String ... var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder resourceSetStatus(String var1);

        public Builder resourceSetStatus(ResourceSetStatus var1);
    }
}

