/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.PossibleRemediationAction;
import software.amazon.awssdk.services.fms.model.PossibleRemediationActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PossibleRemediationActions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PossibleRemediationActions> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PossibleRemediationActions.getter(PossibleRemediationActions::description)).setter(PossibleRemediationActions.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<PossibleRemediationAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(PossibleRemediationActions.getter(PossibleRemediationActions::actions)).setter(PossibleRemediationActions.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PossibleRemediationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<PossibleRemediationAction> actions;

    private PossibleRemediationActions(BuilderImpl builder) {
        this.description = builder.description;
        this.actions = builder.actions;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<PossibleRemediationAction> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PossibleRemediationActions)) {
            return false;
        }
        PossibleRemediationActions other = (PossibleRemediationActions)obj;
        return Objects.equals(this.description(), other.description()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"PossibleRemediationActions").add("Description", (Object)this.description()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PossibleRemediationActions, T> g) {
        return obj -> g.apply((PossibleRemediationActions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<PossibleRemediationAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PossibleRemediationActions model) {
            this.description(model.description);
            this.actions(model.actions);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<PossibleRemediationAction.Builder> getActions() {
            List<PossibleRemediationAction.Builder> result = PossibleRemediationActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<PossibleRemediationAction.BuilderImpl> actions) {
            this.actions = PossibleRemediationActionListCopier.copyFromBuilder(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<PossibleRemediationAction> actions) {
            this.actions = PossibleRemediationActionListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(PossibleRemediationAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Consumer<PossibleRemediationAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (PossibleRemediationAction)((PossibleRemediationAction.Builder)PossibleRemediationAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PossibleRemediationActions build() {
            return new PossibleRemediationActions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PossibleRemediationActions> {
        public Builder description(String var1);

        public Builder actions(Collection<PossibleRemediationAction> var1);

        public Builder actions(PossibleRemediationAction ... var1);

        public Builder actions(Consumer<PossibleRemediationAction.Builder> ... var1);
    }
}

