/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.ActionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2ReplaceRouteAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2ReplaceRouteAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EC2ReplaceRouteAction.getter(EC2ReplaceRouteAction::description)).setter(EC2ReplaceRouteAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(EC2ReplaceRouteAction.getter(EC2ReplaceRouteAction::destinationCidrBlock)).setter(EC2ReplaceRouteAction.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPrefixListId").getter(EC2ReplaceRouteAction.getter(EC2ReplaceRouteAction::destinationPrefixListId)).setter(EC2ReplaceRouteAction.setter(Builder::destinationPrefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").build()}).build();
    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIpv6CidrBlock").getter(EC2ReplaceRouteAction.getter(EC2ReplaceRouteAction::destinationIpv6CidrBlock)).setter(EC2ReplaceRouteAction.setter(Builder::destinationIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").build()}).build();
    private static final SdkField<ActionTarget> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GatewayId").getter(EC2ReplaceRouteAction.getter(EC2ReplaceRouteAction::gatewayId)).setter(EC2ReplaceRouteAction.setter(Builder::gatewayId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<ActionTarget> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTableId").getter(EC2ReplaceRouteAction.getter(EC2ReplaceRouteAction::routeTableId)).setter(EC2ReplaceRouteAction.setter(Builder::routeTableId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD, GATEWAY_ID_FIELD, ROUTE_TABLE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String destinationCidrBlock;
    private final String destinationPrefixListId;
    private final String destinationIpv6CidrBlock;
    private final ActionTarget gatewayId;
    private final ActionTarget routeTableId;

    private EC2ReplaceRouteAction(BuilderImpl builder) {
        this.description = builder.description;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.gatewayId = builder.gatewayId;
        this.routeTableId = builder.routeTableId;
    }

    public final String description() {
        return this.description;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String destinationPrefixListId() {
        return this.destinationPrefixListId;
    }

    public final String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public final ActionTarget gatewayId() {
        return this.gatewayId;
    }

    public final ActionTarget routeTableId() {
        return this.routeTableId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2ReplaceRouteAction)) {
            return false;
        }
        EC2ReplaceRouteAction other = (EC2ReplaceRouteAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationPrefixListId(), other.destinationPrefixListId()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.routeTableId(), other.routeTableId());
    }

    public final String toString() {
        return ToString.builder((String)"EC2ReplaceRouteAction").add("Description", (Object)this.description()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationPrefixListId", (Object)this.destinationPrefixListId()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).add("GatewayId", (Object)this.gatewayId()).add("RouteTableId", (Object)this.routeTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationPrefixListId": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixListId()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2ReplaceRouteAction, T> g) {
        return obj -> g.apply((EC2ReplaceRouteAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String destinationCidrBlock;
        private String destinationPrefixListId;
        private String destinationIpv6CidrBlock;
        private ActionTarget gatewayId;
        private ActionTarget routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2ReplaceRouteAction model) {
            this.description(model.description);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationPrefixListId(model.destinationPrefixListId);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.gatewayId(model.gatewayId);
            this.routeTableId(model.routeTableId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        @Transient
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final ActionTarget.Builder getGatewayId() {
            return this.gatewayId != null ? this.gatewayId.toBuilder() : null;
        }

        public final void setGatewayId(ActionTarget.BuilderImpl gatewayId) {
            this.gatewayId = gatewayId != null ? gatewayId.build() : null;
        }

        @Override
        @Transient
        public final Builder gatewayId(ActionTarget gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final ActionTarget.Builder getRouteTableId() {
            return this.routeTableId != null ? this.routeTableId.toBuilder() : null;
        }

        public final void setRouteTableId(ActionTarget.BuilderImpl routeTableId) {
            this.routeTableId = routeTableId != null ? routeTableId.build() : null;
        }

        @Override
        @Transient
        public final Builder routeTableId(ActionTarget routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public EC2ReplaceRouteAction build() {
            return new EC2ReplaceRouteAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2ReplaceRouteAction> {
        public Builder description(String var1);

        public Builder destinationCidrBlock(String var1);

        public Builder destinationPrefixListId(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder gatewayId(ActionTarget var1);

        default public Builder gatewayId(Consumer<ActionTarget.Builder> gatewayId) {
            return this.gatewayId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(gatewayId)).build());
        }

        public Builder routeTableId(ActionTarget var1);

        default public Builder routeTableId(Consumer<ActionTarget.Builder> routeTableId) {
            return this.routeTableId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(routeTableId)).build());
        }
    }
}

