/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fms.model.ComplianceViolatorMetadataCopier;
import software.amazon.awssdk.services.fms.model.ViolationReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceViolator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComplianceViolator> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ComplianceViolator.getter(ComplianceViolator::resourceId)).setter(ComplianceViolator.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> VIOLATION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationReason").getter(ComplianceViolator.getter(ComplianceViolator::violationReasonAsString)).setter(ComplianceViolator.setter(Builder::violationReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationReason").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ComplianceViolator.getter(ComplianceViolator::resourceType)).setter(ComplianceViolator.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metadata").getter(ComplianceViolator.getter(ComplianceViolator::metadata)).setter(ComplianceViolator.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, VIOLATION_REASON_FIELD, RESOURCE_TYPE_FIELD, METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String violationReason;
    private final String resourceType;
    private final Map<String, String> metadata;

    private ComplianceViolator(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.violationReason = builder.violationReason;
        this.resourceType = builder.resourceType;
        this.metadata = builder.metadata;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ViolationReason violationReason() {
        return ViolationReason.fromValue(this.violationReason);
    }

    public final String violationReasonAsString() {
        return this.violationReason;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceViolator)) {
            return false;
        }
        ComplianceViolator other = (ComplianceViolator)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.violationReasonAsString(), other.violationReasonAsString()) && Objects.equals(this.resourceType(), other.resourceType()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"ComplianceViolator").add("ResourceId", (Object)this.resourceId()).add("ViolationReason", (Object)this.violationReasonAsString()).add("ResourceType", (Object)this.resourceType()).add("Metadata", this.hasMetadata() ? this.metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ViolationReason": {
                return Optional.ofNullable(clazz.cast(this.violationReasonAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceViolator, T> g) {
        return obj -> g.apply((ComplianceViolator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String violationReason;
        private String resourceType;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceViolator model) {
            this.resourceId(model.resourceId);
            this.violationReason(model.violationReason);
            this.resourceType(model.resourceType);
            this.metadata(model.metadata);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getViolationReason() {
            return this.violationReason;
        }

        public final void setViolationReason(String violationReason) {
            this.violationReason = violationReason;
        }

        @Override
        public final Builder violationReason(String violationReason) {
            this.violationReason = violationReason;
            return this;
        }

        @Override
        public final Builder violationReason(ViolationReason violationReason) {
            this.violationReason(violationReason == null ? null : violationReason.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ComplianceViolatorMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ComplianceViolatorMetadataCopier.copy(metadata);
            return this;
        }

        public ComplianceViolator build() {
            return new ComplianceViolator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComplianceViolator> {
        public Builder resourceId(String var1);

        public Builder violationReason(String var1);

        public Builder violationReason(ViolationReason var1);

        public Builder resourceType(String var1);

        public Builder metadata(Map<String, String> var1);
    }
}

