/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.SecurityServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicySummary> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(PolicySummary.getter(PolicySummary::policyArn)).setter(PolicySummary.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(PolicySummary.getter(PolicySummary::policyId)).setter(PolicySummary.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(PolicySummary.getter(PolicySummary::policyName)).setter(PolicySummary.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(PolicySummary.getter(PolicySummary::resourceType)).setter(PolicySummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> SECURITY_SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityServiceType").getter(PolicySummary.getter(PolicySummary::securityServiceTypeAsString)).setter(PolicySummary.setter(Builder::securityServiceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityServiceType").build()}).build();
    private static final SdkField<Boolean> REMEDIATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemediationEnabled").getter(PolicySummary.getter(PolicySummary::remediationEnabled)).setter(PolicySummary.setter(Builder::remediationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, POLICY_ID_FIELD, POLICY_NAME_FIELD, RESOURCE_TYPE_FIELD, SECURITY_SERVICE_TYPE_FIELD, REMEDIATION_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyArn;
    private final String policyId;
    private final String policyName;
    private final String resourceType;
    private final String securityServiceType;
    private final Boolean remediationEnabled;

    private PolicySummary(BuilderImpl builder) {
        this.policyArn = builder.policyArn;
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.resourceType = builder.resourceType;
        this.securityServiceType = builder.securityServiceType;
        this.remediationEnabled = builder.remediationEnabled;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final SecurityServiceType securityServiceType() {
        return SecurityServiceType.fromValue(this.securityServiceType);
    }

    public final String securityServiceTypeAsString() {
        return this.securityServiceType;
    }

    public final Boolean remediationEnabled() {
        return this.remediationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityServiceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicySummary)) {
            return false;
        }
        PolicySummary other = (PolicySummary)obj;
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.securityServiceTypeAsString(), other.securityServiceTypeAsString()) && Objects.equals(this.remediationEnabled(), other.remediationEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"PolicySummary").add("PolicyArn", (Object)this.policyArn()).add("PolicyId", (Object)this.policyId()).add("PolicyName", (Object)this.policyName()).add("ResourceType", (Object)this.resourceType()).add("SecurityServiceType", (Object)this.securityServiceTypeAsString()).add("RemediationEnabled", (Object)this.remediationEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "SecurityServiceType": {
                return Optional.ofNullable(clazz.cast(this.securityServiceTypeAsString()));
            }
            case "RemediationEnabled": {
                return Optional.ofNullable(clazz.cast(this.remediationEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicySummary, T> g) {
        return obj -> g.apply((PolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyArn;
        private String policyId;
        private String policyName;
        private String resourceType;
        private String securityServiceType;
        private Boolean remediationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicySummary model) {
            this.policyArn(model.policyArn);
            this.policyId(model.policyId);
            this.policyName(model.policyName);
            this.resourceType(model.resourceType);
            this.securityServiceType(model.securityServiceType);
            this.remediationEnabled(model.remediationEnabled);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        @Transient
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        @Transient
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        @Transient
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getSecurityServiceType() {
            return this.securityServiceType;
        }

        public final void setSecurityServiceType(String securityServiceType) {
            this.securityServiceType = securityServiceType;
        }

        @Override
        @Transient
        public final Builder securityServiceType(String securityServiceType) {
            this.securityServiceType = securityServiceType;
            return this;
        }

        @Override
        @Transient
        public final Builder securityServiceType(SecurityServiceType securityServiceType) {
            this.securityServiceType(securityServiceType == null ? null : securityServiceType.toString());
            return this;
        }

        public final Boolean getRemediationEnabled() {
            return this.remediationEnabled;
        }

        public final void setRemediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
        }

        @Override
        @Transient
        public final Builder remediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
            return this;
        }

        public PolicySummary build() {
            return new PolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicySummary> {
        public Builder policyArn(String var1);

        public Builder policyId(String var1);

        public Builder policyName(String var1);

        public Builder resourceType(String var1);

        public Builder securityServiceType(String var1);

        public Builder securityServiceType(SecurityServiceType var1);

        public Builder remediationEnabled(Boolean var1);
    }
}

