/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.OrderedRemediationActionsCopier;
import software.amazon.awssdk.services.fms.model.RemediationActionWithOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PossibleRemediationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PossibleRemediationAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PossibleRemediationAction.getter(PossibleRemediationAction::description)).setter(PossibleRemediationAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<RemediationActionWithOrder>> ORDERED_REMEDIATION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderedRemediationActions").getter(PossibleRemediationAction.getter(PossibleRemediationAction::orderedRemediationActions)).setter(PossibleRemediationAction.setter(Builder::orderedRemediationActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedRemediationActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationActionWithOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefaultAction").getter(PossibleRemediationAction.getter(PossibleRemediationAction::isDefaultAction)).setter(PossibleRemediationAction.setter(Builder::isDefaultAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ORDERED_REMEDIATION_ACTIONS_FIELD, IS_DEFAULT_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<RemediationActionWithOrder> orderedRemediationActions;
    private final Boolean isDefaultAction;

    private PossibleRemediationAction(BuilderImpl builder) {
        this.description = builder.description;
        this.orderedRemediationActions = builder.orderedRemediationActions;
        this.isDefaultAction = builder.isDefaultAction;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOrderedRemediationActions() {
        return this.orderedRemediationActions != null && !(this.orderedRemediationActions instanceof SdkAutoConstructList);
    }

    public final List<RemediationActionWithOrder> orderedRemediationActions() {
        return this.orderedRemediationActions;
    }

    public final Boolean isDefaultAction() {
        return this.isDefaultAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderedRemediationActions() ? this.orderedRemediationActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PossibleRemediationAction)) {
            return false;
        }
        PossibleRemediationAction other = (PossibleRemediationAction)obj;
        return Objects.equals(this.description(), other.description()) && this.hasOrderedRemediationActions() == other.hasOrderedRemediationActions() && Objects.equals(this.orderedRemediationActions(), other.orderedRemediationActions()) && Objects.equals(this.isDefaultAction(), other.isDefaultAction());
    }

    public final String toString() {
        return ToString.builder((String)"PossibleRemediationAction").add("Description", (Object)this.description()).add("OrderedRemediationActions", this.hasOrderedRemediationActions() ? this.orderedRemediationActions() : null).add("IsDefaultAction", (Object)this.isDefaultAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OrderedRemediationActions": {
                return Optional.ofNullable(clazz.cast(this.orderedRemediationActions()));
            }
            case "IsDefaultAction": {
                return Optional.ofNullable(clazz.cast(this.isDefaultAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PossibleRemediationAction, T> g) {
        return obj -> g.apply((PossibleRemediationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<RemediationActionWithOrder> orderedRemediationActions = DefaultSdkAutoConstructList.getInstance();
        private Boolean isDefaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(PossibleRemediationAction model) {
            this.description(model.description);
            this.orderedRemediationActions(model.orderedRemediationActions);
            this.isDefaultAction(model.isDefaultAction);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<RemediationActionWithOrder.Builder> getOrderedRemediationActions() {
            List<RemediationActionWithOrder.Builder> result = OrderedRemediationActionsCopier.copyToBuilder(this.orderedRemediationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedRemediationActions(Collection<RemediationActionWithOrder.BuilderImpl> orderedRemediationActions) {
            this.orderedRemediationActions = OrderedRemediationActionsCopier.copyFromBuilder(orderedRemediationActions);
        }

        @Override
        @Transient
        public final Builder orderedRemediationActions(Collection<RemediationActionWithOrder> orderedRemediationActions) {
            this.orderedRemediationActions = OrderedRemediationActionsCopier.copy(orderedRemediationActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder orderedRemediationActions(RemediationActionWithOrder ... orderedRemediationActions) {
            this.orderedRemediationActions(Arrays.asList(orderedRemediationActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder orderedRemediationActions(Consumer<RemediationActionWithOrder.Builder> ... orderedRemediationActions) {
            this.orderedRemediationActions(Stream.of(orderedRemediationActions).map(c -> (RemediationActionWithOrder)((RemediationActionWithOrder.Builder)RemediationActionWithOrder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsDefaultAction() {
            return this.isDefaultAction;
        }

        public final void setIsDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
        }

        @Override
        @Transient
        public final Builder isDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
            return this;
        }

        public PossibleRemediationAction build() {
            return new PossibleRemediationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PossibleRemediationAction> {
        public Builder description(String var1);

        public Builder orderedRemediationActions(Collection<RemediationActionWithOrder> var1);

        public Builder orderedRemediationActions(RemediationActionWithOrder ... var1);

        public Builder orderedRemediationActions(Consumer<RemediationActionWithOrder.Builder> ... var1);

        public Builder isDefaultAction(Boolean var1);
    }
}

