/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.Policy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPolicyResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, GetPolicyResponse> {
    private static final SdkField<Policy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Policy").getter(GetPolicyResponse.getter(GetPolicyResponse::policy)).setter(GetPolicyResponse.setter(Builder::policy)).constructor(Policy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(GetPolicyResponse.getter(GetPolicyResponse::policyArn)).setter(GetPolicyResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, POLICY_ARN_FIELD));
    private final Policy policy;
    private final String policyArn;

    private GetPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.policyArn = builder.policyArn;
    }

    public final Policy policy() {
        return this.policy;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyResponse)) {
            return false;
        }
        GetPolicyResponse other = (GetPolicyResponse)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && Objects.equals(this.policyArn(), other.policyArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetPolicyResponse").add("Policy", (Object)this.policy()).add("PolicyArn", (Object)this.policyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyResponse, T> g) {
        return obj -> g.apply((GetPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private Policy policy;
        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyResponse model) {
            super(model);
            this.policy(model.policy);
            this.policyArn(model.policyArn);
        }

        public final Policy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        public final void setPolicy(Policy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        @Transient
        public final Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        @Transient
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        @Override
        public GetPolicyResponse build() {
            return new GetPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPolicyResponse> {
        public Builder policy(Policy var1);

        default public Builder policy(Consumer<Policy.Builder> policy) {
            return this.policy((Policy)((Policy.Builder)Policy.builder().applyMutation(policy)).build());
        }

        public Builder policyArn(String var1);
    }
}

