/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.FmsRequest;
import software.amazon.awssdk.services.fms.model.Policy;
import software.amazon.awssdk.services.fms.model.Tag;
import software.amazon.awssdk.services.fms.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPolicyRequest
extends FmsRequest
implements ToCopyableBuilder<Builder, PutPolicyRequest> {
    private static final SdkField<Policy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Policy").getter(PutPolicyRequest.getter(PutPolicyRequest::policy)).setter(PutPolicyRequest.setter(Builder::policy)).constructor(Policy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(PutPolicyRequest.getter(PutPolicyRequest::tagList)).setter(PutPolicyRequest.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, TAG_LIST_FIELD));
    private final Policy policy;
    private final List<Tag> tagList;

    private PutPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.tagList = builder.tagList;
    }

    public final Policy policy() {
        return this.policy;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPolicyRequest)) {
            return false;
        }
        PutPolicyRequest other = (PutPolicyRequest)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList());
    }

    public final String toString() {
        return ToString.builder((String)"PutPolicyRequest").add("Policy", (Object)this.policy()).add("TagList", this.hasTagList() ? this.tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPolicyRequest, T> g) {
        return obj -> g.apply((PutPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsRequest.BuilderImpl
    implements Builder {
        private Policy policy;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutPolicyRequest model) {
            super(model);
            this.policy(model.policy);
            this.tagList(model.tagList);
        }

        public final Policy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        @Override
        public final Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(Policy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPolicyRequest build() {
            return new PutPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPolicyRequest> {
        public Builder policy(Policy var1);

        default public Builder policy(Consumer<Policy.Builder> policy) {
            return this.policy((Policy)((Policy.Builder)Policy.builder().applyMutation(policy)).build());
        }

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

