/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation;
import software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2InstanceViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2InstanceViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTarget").getter(AwsEc2InstanceViolation.getter(AwsEc2InstanceViolation::violationTarget)).setter(AwsEc2InstanceViolation.setter(Builder::violationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()}).build();
    private static final SdkField<List<AwsEc2NetworkInterfaceViolation>> AWS_EC2_NETWORK_INTERFACE_VIOLATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsEc2NetworkInterfaceViolations").getter(AwsEc2InstanceViolation.getter(AwsEc2InstanceViolation::awsEc2NetworkInterfaceViolations)).setter(AwsEc2InstanceViolation.setter(Builder::awsEc2NetworkInterfaceViolations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2NetworkInterfaceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD, AWS_EC2_NETWORK_INTERFACE_VIOLATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String violationTarget;
    private final List<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations;

    private AwsEc2InstanceViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.awsEc2NetworkInterfaceViolations = builder.awsEc2NetworkInterfaceViolations;
    }

    public String violationTarget() {
        return this.violationTarget;
    }

    public boolean hasAwsEc2NetworkInterfaceViolations() {
        return this.awsEc2NetworkInterfaceViolations != null && !(this.awsEc2NetworkInterfaceViolations instanceof SdkAutoConstructList);
    }

    public List<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations() {
        return this.awsEc2NetworkInterfaceViolations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2NetworkInterfaceViolations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceViolation)) {
            return false;
        }
        AwsEc2InstanceViolation other = (AwsEc2InstanceViolation)obj;
        return Objects.equals(this.violationTarget(), other.violationTarget()) && Objects.equals(this.awsEc2NetworkInterfaceViolations(), other.awsEc2NetworkInterfaceViolations());
    }

    public String toString() {
        return ToString.builder((String)"AwsEc2InstanceViolation").add("ViolationTarget", (Object)this.violationTarget()).add("AwsEc2NetworkInterfaceViolations", this.awsEc2NetworkInterfaceViolations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViolationTarget": {
                return Optional.ofNullable(clazz.cast(this.violationTarget()));
            }
            case "AwsEc2NetworkInterfaceViolations": {
                return Optional.ofNullable(clazz.cast(this.awsEc2NetworkInterfaceViolations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceViolation, T> g) {
        return obj -> g.apply((AwsEc2InstanceViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationTarget;
        private List<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceViolation model) {
            this.violationTarget(model.violationTarget);
            this.awsEc2NetworkInterfaceViolations(model.awsEc2NetworkInterfaceViolations);
        }

        public final String getViolationTarget() {
            return this.violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        public final Collection<AwsEc2NetworkInterfaceViolation.Builder> getAwsEc2NetworkInterfaceViolations() {
            return this.awsEc2NetworkInterfaceViolations != null ? (Collection)this.awsEc2NetworkInterfaceViolations.stream().map(AwsEc2NetworkInterfaceViolation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder awsEc2NetworkInterfaceViolations(Collection<AwsEc2NetworkInterfaceViolation> awsEc2NetworkInterfaceViolations) {
            this.awsEc2NetworkInterfaceViolations = AwsEc2NetworkInterfaceViolationsCopier.copy(awsEc2NetworkInterfaceViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsEc2NetworkInterfaceViolations(AwsEc2NetworkInterfaceViolation ... awsEc2NetworkInterfaceViolations) {
            this.awsEc2NetworkInterfaceViolations(Arrays.asList(awsEc2NetworkInterfaceViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsEc2NetworkInterfaceViolations(Consumer<AwsEc2NetworkInterfaceViolation.Builder> ... awsEc2NetworkInterfaceViolations) {
            this.awsEc2NetworkInterfaceViolations(Stream.of(awsEc2NetworkInterfaceViolations).map(c -> (AwsEc2NetworkInterfaceViolation)((AwsEc2NetworkInterfaceViolation.Builder)AwsEc2NetworkInterfaceViolation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAwsEc2NetworkInterfaceViolations(Collection<AwsEc2NetworkInterfaceViolation.BuilderImpl> awsEc2NetworkInterfaceViolations) {
            this.awsEc2NetworkInterfaceViolations = AwsEc2NetworkInterfaceViolationsCopier.copyFromBuilder(awsEc2NetworkInterfaceViolations);
        }

        public AwsEc2InstanceViolation build() {
            return new AwsEc2InstanceViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2InstanceViolation> {
        public Builder violationTarget(String var1);

        public Builder awsEc2NetworkInterfaceViolations(Collection<AwsEc2NetworkInterfaceViolation> var1);

        public Builder awsEc2NetworkInterfaceViolations(AwsEc2NetworkInterfaceViolation ... var1);

        public Builder awsEc2NetworkInterfaceViolations(Consumer<AwsEc2NetworkInterfaceViolation.Builder> ... var1);
    }
}

