/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation;
import software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation;
import software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceViolation> {
    private static final SdkField<AwsVPCSecurityGroupViolation> AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsVPCSecurityGroupViolation").getter(ResourceViolation.getter(ResourceViolation::awsVPCSecurityGroupViolation)).setter(ResourceViolation.setter(Builder::awsVPCSecurityGroupViolation)).constructor(AwsVPCSecurityGroupViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsVPCSecurityGroupViolation").build()}).build();
    private static final SdkField<AwsEc2NetworkInterfaceViolation> AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsEc2NetworkInterfaceViolation").getter(ResourceViolation.getter(ResourceViolation::awsEc2NetworkInterfaceViolation)).setter(ResourceViolation.setter(Builder::awsEc2NetworkInterfaceViolation)).constructor(AwsEc2NetworkInterfaceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolation").build()}).build();
    private static final SdkField<AwsEc2InstanceViolation> AWS_EC2_INSTANCE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsEc2InstanceViolation").getter(ResourceViolation.getter(ResourceViolation::awsEc2InstanceViolation)).setter(ResourceViolation.setter(Builder::awsEc2InstanceViolation)).constructor(AwsEc2InstanceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2InstanceViolation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD, AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD, AWS_EC2_INSTANCE_VIOLATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;
    private final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;
    private final AwsEc2InstanceViolation awsEc2InstanceViolation;

    private ResourceViolation(BuilderImpl builder) {
        this.awsVPCSecurityGroupViolation = builder.awsVPCSecurityGroupViolation;
        this.awsEc2NetworkInterfaceViolation = builder.awsEc2NetworkInterfaceViolation;
        this.awsEc2InstanceViolation = builder.awsEc2InstanceViolation;
    }

    public AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation() {
        return this.awsVPCSecurityGroupViolation;
    }

    public AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation() {
        return this.awsEc2NetworkInterfaceViolation;
    }

    public AwsEc2InstanceViolation awsEc2InstanceViolation() {
        return this.awsEc2InstanceViolation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsVPCSecurityGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2NetworkInterfaceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2InstanceViolation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceViolation)) {
            return false;
        }
        ResourceViolation other = (ResourceViolation)obj;
        return Objects.equals(this.awsVPCSecurityGroupViolation(), other.awsVPCSecurityGroupViolation()) && Objects.equals(this.awsEc2NetworkInterfaceViolation(), other.awsEc2NetworkInterfaceViolation()) && Objects.equals(this.awsEc2InstanceViolation(), other.awsEc2InstanceViolation());
    }

    public String toString() {
        return ToString.builder((String)"ResourceViolation").add("AwsVPCSecurityGroupViolation", (Object)this.awsVPCSecurityGroupViolation()).add("AwsEc2NetworkInterfaceViolation", (Object)this.awsEc2NetworkInterfaceViolation()).add("AwsEc2InstanceViolation", (Object)this.awsEc2InstanceViolation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsVPCSecurityGroupViolation": {
                return Optional.ofNullable(clazz.cast(this.awsVPCSecurityGroupViolation()));
            }
            case "AwsEc2NetworkInterfaceViolation": {
                return Optional.ofNullable(clazz.cast(this.awsEc2NetworkInterfaceViolation()));
            }
            case "AwsEc2InstanceViolation": {
                return Optional.ofNullable(clazz.cast(this.awsEc2InstanceViolation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceViolation, T> g) {
        return obj -> g.apply((ResourceViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;
        private AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;
        private AwsEc2InstanceViolation awsEc2InstanceViolation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceViolation model) {
            this.awsVPCSecurityGroupViolation(model.awsVPCSecurityGroupViolation);
            this.awsEc2NetworkInterfaceViolation(model.awsEc2NetworkInterfaceViolation);
            this.awsEc2InstanceViolation(model.awsEc2InstanceViolation);
        }

        public final AwsVPCSecurityGroupViolation.Builder getAwsVPCSecurityGroupViolation() {
            return this.awsVPCSecurityGroupViolation != null ? this.awsVPCSecurityGroupViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation;
            return this;
        }

        public final void setAwsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.BuilderImpl awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.build() : null;
        }

        public final AwsEc2NetworkInterfaceViolation.Builder getAwsEc2NetworkInterfaceViolation() {
            return this.awsEc2NetworkInterfaceViolation != null ? this.awsEc2NetworkInterfaceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation;
            return this;
        }

        public final void setAwsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation.BuilderImpl awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation.build() : null;
        }

        public final AwsEc2InstanceViolation.Builder getAwsEc2InstanceViolation() {
            return this.awsEc2InstanceViolation != null ? this.awsEc2InstanceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation;
            return this;
        }

        public final void setAwsEc2InstanceViolation(AwsEc2InstanceViolation.BuilderImpl awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation != null ? awsEc2InstanceViolation.build() : null;
        }

        public ResourceViolation build() {
            return new ResourceViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceViolation> {
        public Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation var1);

        default public Builder awsVPCSecurityGroupViolation(Consumer<AwsVPCSecurityGroupViolation.Builder> awsVPCSecurityGroupViolation) {
            return this.awsVPCSecurityGroupViolation((AwsVPCSecurityGroupViolation)((AwsVPCSecurityGroupViolation.Builder)AwsVPCSecurityGroupViolation.builder().applyMutation(awsVPCSecurityGroupViolation)).build());
        }

        public Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation var1);

        default public Builder awsEc2NetworkInterfaceViolation(Consumer<AwsEc2NetworkInterfaceViolation.Builder> awsEc2NetworkInterfaceViolation) {
            return this.awsEc2NetworkInterfaceViolation((AwsEc2NetworkInterfaceViolation)((AwsEc2NetworkInterfaceViolation.Builder)AwsEc2NetworkInterfaceViolation.builder().applyMutation(awsEc2NetworkInterfaceViolation)).build());
        }

        public Builder awsEc2InstanceViolation(AwsEc2InstanceViolation var1);

        default public Builder awsEc2InstanceViolation(Consumer<AwsEc2InstanceViolation.Builder> awsEc2InstanceViolation) {
            return this.awsEc2InstanceViolation((AwsEc2InstanceViolation)((AwsEc2InstanceViolation.Builder)AwsEc2InstanceViolation.builder().applyMutation(awsEc2InstanceViolation)).build());
        }
    }
}

