/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fms.model.PreviousProtocolsListCopier;
import software.amazon.awssdk.services.fms.model.ProtocolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtocolsListData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtocolsListData> {
    private static final SdkField<String> LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProtocolsListData.getter(ProtocolsListData::listId)).setter(ProtocolsListData.setter(Builder::listId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()}).build();
    private static final SdkField<String> LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProtocolsListData.getter(ProtocolsListData::listName)).setter(ProtocolsListData.setter(Builder::listName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()}).build();
    private static final SdkField<String> LIST_UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProtocolsListData.getter(ProtocolsListData::listUpdateToken)).setter(ProtocolsListData.setter(Builder::listUpdateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListUpdateToken").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProtocolsListData.getter(ProtocolsListData::createTime)).setter(ProtocolsListData.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProtocolsListData.getter(ProtocolsListData::lastUpdateTime)).setter(ProtocolsListData.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProtocolsListData.getter(ProtocolsListData::protocolsList)).setter(ProtocolsListData.setter(Builder::protocolsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> PREVIOUS_PROTOCOLS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ProtocolsListData.getter(ProtocolsListData::previousProtocolsList)).setter(ProtocolsListData.setter(Builder::previousProtocolsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousProtocolsList").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ID_FIELD, LIST_NAME_FIELD, LIST_UPDATE_TOKEN_FIELD, CREATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD, PROTOCOLS_LIST_FIELD, PREVIOUS_PROTOCOLS_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String listId;
    private final String listName;
    private final String listUpdateToken;
    private final Instant createTime;
    private final Instant lastUpdateTime;
    private final List<String> protocolsList;
    private final Map<String, List<String>> previousProtocolsList;

    private ProtocolsListData(BuilderImpl builder) {
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.listUpdateToken = builder.listUpdateToken;
        this.createTime = builder.createTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.protocolsList = builder.protocolsList;
        this.previousProtocolsList = builder.previousProtocolsList;
    }

    public String listId() {
        return this.listId;
    }

    public String listName() {
        return this.listName;
    }

    public String listUpdateToken() {
        return this.listUpdateToken;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean hasProtocolsList() {
        return this.protocolsList != null && !(this.protocolsList instanceof SdkAutoConstructList);
    }

    public List<String> protocolsList() {
        return this.protocolsList;
    }

    public boolean hasPreviousProtocolsList() {
        return this.previousProtocolsList != null && !(this.previousProtocolsList instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> previousProtocolsList() {
        return this.previousProtocolsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listUpdateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousProtocolsList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolsListData)) {
            return false;
        }
        ProtocolsListData other = (ProtocolsListData)obj;
        return Objects.equals(this.listId(), other.listId()) && Objects.equals(this.listName(), other.listName()) && Objects.equals(this.listUpdateToken(), other.listUpdateToken()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.protocolsList(), other.protocolsList()) && Objects.equals(this.previousProtocolsList(), other.previousProtocolsList());
    }

    public String toString() {
        return ToString.builder((String)"ProtocolsListData").add("ListId", (Object)this.listId()).add("ListName", (Object)this.listName()).add("ListUpdateToken", (Object)this.listUpdateToken()).add("CreateTime", (Object)this.createTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("ProtocolsList", this.protocolsList()).add("PreviousProtocolsList", this.previousProtocolsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListId": {
                return Optional.ofNullable(clazz.cast(this.listId()));
            }
            case "ListName": {
                return Optional.ofNullable(clazz.cast(this.listName()));
            }
            case "ListUpdateToken": {
                return Optional.ofNullable(clazz.cast(this.listUpdateToken()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "ProtocolsList": {
                return Optional.ofNullable(clazz.cast(this.protocolsList()));
            }
            case "PreviousProtocolsList": {
                return Optional.ofNullable(clazz.cast(this.previousProtocolsList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtocolsListData, T> g) {
        return obj -> g.apply((ProtocolsListData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String listId;
        private String listName;
        private String listUpdateToken;
        private Instant createTime;
        private Instant lastUpdateTime;
        private List<String> protocolsList = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> previousProtocolsList = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolsListData model) {
            this.listId(model.listId);
            this.listName(model.listName);
            this.listUpdateToken(model.listUpdateToken);
            this.createTime(model.createTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.protocolsList(model.protocolsList);
            this.previousProtocolsList(model.previousProtocolsList);
        }

        public final String getListId() {
            return this.listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final String getListName() {
            return this.listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        public final String getListUpdateToken() {
            return this.listUpdateToken;
        }

        @Override
        public final Builder listUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
            return this;
        }

        public final void setListUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final Collection<String> getProtocolsList() {
            return this.protocolsList;
        }

        @Override
        public final Builder protocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsList(String ... protocolsList) {
            this.protocolsList(Arrays.asList(protocolsList));
            return this;
        }

        public final void setProtocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
        }

        public final Map<String, ? extends Collection<String>> getPreviousProtocolsList() {
            return this.previousProtocolsList;
        }

        @Override
        public final Builder previousProtocolsList(Map<String, ? extends Collection<String>> previousProtocolsList) {
            this.previousProtocolsList = PreviousProtocolsListCopier.copy(previousProtocolsList);
            return this;
        }

        public final void setPreviousProtocolsList(Map<String, ? extends Collection<String>> previousProtocolsList) {
            this.previousProtocolsList = PreviousProtocolsListCopier.copy(previousProtocolsList);
        }

        public ProtocolsListData build() {
            return new ProtocolsListData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtocolsListData> {
        public Builder listId(String var1);

        public Builder listName(String var1);

        public Builder listUpdateToken(String var1);

        public Builder createTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder protocolsList(Collection<String> var1);

        public Builder protocolsList(String ... var1);

        public Builder previousProtocolsList(Map<String, ? extends Collection<String>> var1);
    }
}

