/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fis.model.FisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentResolvedTargetsRequest
extends FisRequest
implements ToCopyableBuilder<Builder, ListExperimentResolvedTargetsRequest> {
    private static final SdkField<String> EXPERIMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experimentId").getter(ListExperimentResolvedTargetsRequest.getter(ListExperimentResolvedTargetsRequest::experimentId)).setter(ListExperimentResolvedTargetsRequest.setter(Builder::experimentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListExperimentResolvedTargetsRequest.getter(ListExperimentResolvedTargetsRequest::maxResults)).setter(ListExperimentResolvedTargetsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExperimentResolvedTargetsRequest.getter(ListExperimentResolvedTargetsRequest::nextToken)).setter(ListExperimentResolvedTargetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetName").getter(ListExperimentResolvedTargetsRequest.getter(ListExperimentResolvedTargetsRequest::targetName)).setter(ListExperimentResolvedTargetsRequest.setter(Builder::targetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TARGET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExperimentResolvedTargetsRequest.memberNameToFieldInitializer();
    private final String experimentId;
    private final Integer maxResults;
    private final String nextToken;
    private final String targetName;

    private ListExperimentResolvedTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.experimentId = builder.experimentId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.targetName = builder.targetName;
    }

    public final String experimentId() {
        return this.experimentId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String targetName() {
        return this.targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentResolvedTargetsRequest)) {
            return false;
        }
        ListExperimentResolvedTargetsRequest other = (ListExperimentResolvedTargetsRequest)((Object)obj);
        return Objects.equals(this.experimentId(), other.experimentId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.targetName(), other.targetName());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentResolvedTargetsRequest").add("ExperimentId", (Object)this.experimentId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("TargetName", (Object)this.targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "experimentId": {
                return Optional.ofNullable(clazz.cast(this.experimentId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "targetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", EXPERIMENT_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("targetName", TARGET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentResolvedTargetsRequest, T> g) {
        return obj -> g.apply((ListExperimentResolvedTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisRequest.BuilderImpl
    implements Builder {
        private String experimentId;
        private Integer maxResults;
        private String nextToken;
        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentResolvedTargetsRequest model) {
            super(model);
            this.experimentId(model.experimentId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.targetName(model.targetName);
        }

        public final String getExperimentId() {
            return this.experimentId;
        }

        public final void setExperimentId(String experimentId) {
            this.experimentId = experimentId;
        }

        @Override
        public final Builder experimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExperimentResolvedTargetsRequest build() {
            return new ListExperimentResolvedTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentResolvedTargetsRequest> {
        public Builder experimentId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder targetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

